/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.implementation;

import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.composite.implementation.CompositeInterfaceAttributeImplicitVariable;
import com.intellij.jsf.model.jam.JsfJamComponent;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.jsp.el.impl.JspImplicitVariableWithCustomResolve;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeComponentImplicitVariable
extends JspImplicitVariableImpl
implements JspImplicitVariableWithCustomResolve {
    private XmlFile myContainingFile;
    private static String COMPOSITE_COMPONENT_VAR_NAME = "cc";
    private static String ATTRS_VAR_NAME = "attrs";
    private static String RESOURCE_BUNDLE_VAR_NAME = "resourceBundleMap";
    private static String PARENT_VAR_NAME = "parent";
    private static List<String> DONT_SHOW_PROPERTIES = Arrays.asList(PARENT_VAR_NAME, RESOURCE_BUNDLE_VAR_NAME, "attributes");

    private CompositeComponentImplicitVariable(@NotNull FakePsiElement element, @NotNull XmlFile xmlFile, @NotNull String varName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "<init>"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "<init>"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "<init>"));
        }
        super((PsiElement)element, varName, null, (PsiElement)element, "NESTED");
        this.myContainingFile = xmlFile;
    }

    public static CompositeComponentImplicitVariable create(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "create"));
        }
        return CompositeComponentImplicitVariable.create(file, COMPOSITE_COMPONENT_VAR_NAME);
    }

    public static CompositeComponentImplicitVariable create(@NotNull XmlFile file, @NotNull String varName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "create"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "create"));
        }
        return new CompositeComponentImplicitVariable(CompositeComponentImplicitVariable.createFakePsiElement((PsiFile)file), file, varName);
    }

    public static FakePsiElement createFakePsiElement(final @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "createFakePsiElement"));
        }
        return new FakePsiElement(){

            public PsiElement getParent() {
                return containingFile;
            }

            public PsiManager getManager() {
                return containingFile.getManager();
            }
        };
    }

    public boolean process(ELExpression element, ELElementProcessor processor) {
        PsiClass classType;
        String componentType;
        XmlTag interfaceTag = CompositeUtil.findInterfaceTag(this.myContainingFile);
        if (interfaceTag != null && (componentType = interfaceTag.getAttributeValue("componentType")) != null && (classType = this.findCompositeComponentType(componentType)) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = classType.getAllMethods()) {
                if (processor.processMethod(method)) continue;
                return false;
            }
        }
        for (JspImplicitVariable variable : CompositeComponentImplicitVariable.getCompositeComponentVariables((PsiFile)this.getProcessingFile())) {
            if (!processor.processVariable((PsiVariable)variable)) break;
        }
        return true;
    }

    @Nullable
    private PsiClass findCompositeComponentType(@NotNull String componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "findCompositeComponentType"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myContainingFile);
        if (module != null) {
            List<JsfJamComponent> components = JsfJamModel.getModel(module).getComponents(true);
            for (JsfJamComponent component : components) {
                if (!componentType.equals(component.getComponentName())) continue;
                return component.getPsiElement();
            }
        }
        return null;
    }

    @Nullable
    protected XmlFile getProcessingFile() {
        return this.myContainingFile;
    }

    @NotNull
    protected PsiType computeType() {
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeByFQClassName("javax.faces.component.UIComponent");
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "computeType"));
        }
        return psiClassType;
    }

    private static JspImplicitVariable[] getCompositeComponentVariables(@Nullable PsiFile file) {
        HashSet<JspImplicitVariable> variables = new HashSet<JspImplicitVariable>();
        if (file instanceof XmlFile) {
            FakePsiElement fakePsiElement = CompositeComponentImplicitVariable.createFakePsiElement(file);
            variables.add((JspImplicitVariable)new CompositeAttributesImplicitVariable((PsiElement)fakePsiElement));
            variables.add((JspImplicitVariable)new JspImplicitVariableImpl((PsiElement)fakePsiElement, "clientId", null, (PsiElement)fakePsiElement, "NESTED"));
            CompositeComponentImplicitVariable.addParentCompositeComponentVariable(variables, (XmlFile)file);
            variables.add((JspImplicitVariable)new CompositeResourceBundleMapImplicitVariable((PsiElement)fakePsiElement, file));
            CompositeComponentImplicitVariable.addUIComponentProperties(variables, fakePsiElement, file.getProject());
        }
        return variables.toArray(new JspImplicitVariable[variables.size()]);
    }

    private static void addParentCompositeComponentVariable(Set<JspImplicitVariable> variables, final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "addParentCompositeComponentVariable"));
        }
        FakePsiElement element = new FakePsiElement(){

            public PsiElement getParent() {
                return file;
            }

            public PsiManager getManager() {
                return file.getManager();
            }

            @NotNull
            public PsiElement getNavigationElement() {
                XmlFile parentFile = CompositeComponentImplicitVariable.getParentComponent(file);
                Object object = parentFile == null ? super.getNavigationElement() : parentFile;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable$2", "getNavigationElement"));
                }
                return object;
            }
        };
        variables.add((JspImplicitVariable)new CompositeComponentImplicitVariable(element, file, PARENT_VAR_NAME){

            @Override
            @Nullable
            protected XmlFile getProcessingFile() {
                return CompositeComponentImplicitVariable.getParentComponent(file);
            }
        });
    }

    @Nullable
    private static XmlFile getParentComponent(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable", "getParentComponent"));
        }
        Set<XmlFile> files = CompositeUtil.getParentComponents(file);
        if (files.size() > 0) {
            return files.iterator().next();
        }
        return null;
    }

    private static void addUIComponentProperties(Set<JspImplicitVariable> variables, FakePsiElement fakePsiElement, Project project) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass("javax.faces.component.UIComponent", GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            for (Map.Entry entry : PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)false, (boolean)true).entrySet()) {
                PsiType type;
                String name = (String)entry.getKey();
                if (DONT_SHOW_PROPERTIES.contains(name) || (type = ((PsiMethod)entry.getValue()).getReturnType()) == null) continue;
                variables.add((JspImplicitVariable)new JspImplicitVariableImpl((PsiElement)fakePsiElement, name, type, (PsiElement)entry.getValue(), "NESTED"));
            }
        }
    }

    public static List<JspImplicitVariable> getAttributeVars(XmlFile containingFile, String prefix) {
        ArrayList<JspImplicitVariable> vars = new ArrayList<JspImplicitVariable>();
        Set<XmlAttributeDescriptor> descriptors = CompositeUtil.getCompositeComponentXmlAttributeDescriptors(containingFile);
        for (XmlAttributeDescriptor descriptor : descriptors) {
            if (descriptor.getDeclaration() == null) continue;
            vars.add((JspImplicitVariable)new CompositeInterfaceAttributeImplicitVariable(descriptor, prefix));
        }
        return vars;
    }

    private static class CompositeResourceBundleMapImplicitVariable
    extends JspImplicitVariableImpl
    implements JspImplicitVariableWithCustomResolve {
        private final PsiFile myFile;

        public CompositeResourceBundleMapImplicitVariable(PsiElement element, @NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable$CompositeResourceBundleMapImplicitVariable", "<init>"));
            }
            super(element, RESOURCE_BUNDLE_VAR_NAME, (PsiType)PsiType.VOID, element, "NESTED");
            this.myFile = file;
        }

        public boolean process(ELExpression element, ELElementProcessor processor) {
            PsiFile file;
            PsiDirectory psiDirectory = this.myFile.getOriginalFile().getContainingDirectory();
            if (psiDirectory != null && (file = psiDirectory.findFile(FileUtil.getNameWithoutExtension((String)this.myFile.getName()) + "." + "properties")) instanceof PropertiesFile) {
                for (IProperty property : ((PropertiesFile)file).getProperties()) {
                    if (processor.processVariable(CompositeResourceBundleMapImplicitVariable.createPropertyVariable(property))) continue;
                    return false;
                }
            }
            return true;
        }

        private static PsiVariable createPropertyVariable(IProperty property) {
            return new JspImplicitVariableImpl(property.getPsiElement(), property.getName(), (PsiType)PsiType.getJavaLangString((PsiManager)property.getPsiElement().getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)property.getPsiElement().getProject())), property.getPsiElement(), "NESTED");
        }
    }

    private static class CompositeAttributesImplicitVariable
    extends JspImplicitVariableImpl
    implements JspImplicitVariableWithCustomResolve {
        public CompositeAttributesImplicitVariable(PsiElement scope) {
            super(scope, ATTRS_VAR_NAME, null, scope, "NESTED");
        }

        public boolean process(ELExpression element, ELElementProcessor processor) {
            for (PsiVariable psiVariable : CompositeComponentImplicitVariable.getAttributeVars((XmlFile)this.getContainingFile(), "")) {
                if (processor.processVariable(psiVariable)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        protected PsiType computeType() {
            PsiType psiType = ELResolveUtil.createTypedMapType((PsiElement)this, (String)"java.lang.String", (String)"java.lang.Object");
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/implementation/CompositeComponentImplicitVariable$CompositeAttributesImplicitVariable", "computeType"));
            }
            return psiType;
        }
    }
}

