/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facet;

import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.facet.AddFacesSupportUtil;
import com.intellij.jsf.library.JsfLibraryType;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfCoreFrameworkType
extends LibraryBasedFrameworkType {
    public static String ID = "jsf:core";

    public JsfCoreFrameworkType() {
        super(ID, JsfLibraryType.class);
    }

    @NotNull
    public String getPresentableName() {
        if ("JSF" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facet/JsfCoreFrameworkType", "getPresentableName"));
        }
        return "JSF";
    }

    @Nullable
    public String getUnderlyingFrameworkTypeId() {
        return FacetBasedFrameworkSupportProvider.getProviderId((FacetTypeId)WebFacet.ID);
    }

    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        LibraryBasedFrameworkSupportProvider libraryBasedFrameworkSupportProvider = new LibraryBasedFrameworkSupportProvider((FrameworkTypeEx)this, this.getLibraryTypeClass()){

            @NotNull
            public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/jsf/facet/JsfCoreFrameworkType$1", "createConfigurable"));
                }
                MyGenerateConfigurable myGenerateConfigurable = new MyGenerateConfigurable();
                if (myGenerateConfigurable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facet/JsfCoreFrameworkType$1", "createConfigurable"));
                }
                return myGenerateConfigurable;
            }
        };
        if (libraryBasedFrameworkSupportProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facet/JsfCoreFrameworkType", "createProvider"));
        }
        return libraryBasedFrameworkSupportProvider;
    }

    @Nullable
    private static String getWebInfPath(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/facet/JsfCoreFrameworkType", "getWebInfPath"));
        }
        for (WebRoot root : webFacet.getWebRoots()) {
            VirtualFile file = root.getFile();
            if (file == null || file.findChild("WEB-INF") == null) continue;
            return root.getDirectoryUrl() + "/WEB-INF/";
        }
        return ((WebRoot)webFacet.getWebRoots().get(0)).getDirectoryUrl() + "/WEB-INF/";
    }

    private static void createFacesConfigXmlInWriteCommandAction(final @NotNull WebFacet webFacet, final @NotNull String path) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/facet/JsfCoreFrameworkType", "createFacesConfigXmlInWriteCommandAction"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/jsf/facet/JsfCoreFrameworkType", "createFacesConfigXmlInWriteCommandAction"));
        }
        final Module module = webFacet.getModule();
        final String templateName = JsfCoreFrameworkType.chooseFileTemplate(module);
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            protected void run() {
                try {
                    FileTemplate template;
                    File configFile = new File(FileUtil.toSystemDependentName((String)path));
                    if (!configFile.exists() && (template = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(templateName)) != null) {
                        FileUtil.createIfDoesntExist((File)configFile);
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
                        if (file != null) {
                            String text = template.getText();
                            VfsUtil.saveText((VirtualFile)file, (String)text);
                            AddFacesSupportUtil.write2WebXml(webFacet, file);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.execute();
    }

    private static String chooseFileTemplate(Module module) {
        if (JsfCommonUtils.isJsf_2_2(module)) {
            return "faces-config.2_2.xml";
        }
        return "faces-config.2_0.xml";
    }

    private class MyGenerateConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private JCheckBox myCreateFacesXml = new JCheckBox("Create faces-config.xml");
        private JCheckBox myCreateIndexXhtml = new JCheckBox("Create index.xhtml");

        private MyGenerateConfigurable() {
        }

        public JComponent createComponent() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            panel.add((Component)this.myCreateFacesXml, gc);
            this.myCreateFacesXml.setSelected(true);
            return panel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/facet/JsfCoreFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/jsf/facet/JsfCoreFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/jsf/facet/JsfCoreFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            Project project = module.getProject();
            if (this.myCreateFacesXml.isSelected()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (modifiableModelsProvider == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/jsf/facet/JsfCoreFrameworkType$MyGenerateConfigurable", "lambda$addSupport$0"));
                    }
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/facet/JsfCoreFrameworkType$MyGenerateConfigurable", "lambda$addSupport$0"));
                    }
                    String path = null;
                    WebFacet webFacet = (WebFacet)modifiableModelsProvider.getFacetModifiableModel(module).findFacet(WebFacet.ID, "Web");
                    if (webFacet != null) {
                        path = JsfCoreFrameworkType.getWebInfPath(webFacet);
                    }
                    if (path != null) {
                        String facesConfigXmlPath = VfsUtilCore.urlToPath((String)(path + "faces-config.xml"));
                        JsfCoreFrameworkType.createFacesConfigXmlInWriteCommandAction(webFacet, facesConfigXmlPath);
                    }
                });
            }
        }

        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(JsfCoreFrameworkType.this.getLibraryTypeClass());
        }
    }
}

