/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JspElInCssInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jsp/JspElInCssInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsp/JspElInCssInjector", "getLanguagesToInject"));
        }
        PsiElement valueElement = ((CssUri)context).getValueElement();
        if (valueElement == null) {
            return;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)valueElement);
        if (manipulator == null) {
            return;
        }
        String text = manipulator.getRangeInElement(valueElement).substring(valueElement.getText());
        if (!text.startsWith("#{") && !text.startsWith("${")) {
            return;
        }
        if (valueElement instanceof CssString) {
            PsiElement child = valueElement.getFirstChild();
            if (child instanceof CssTokenImpl && child == valueElement.getLastChild() && text.endsWith("}")) {
                TextRange range = ElementManipulators.getValueTextRange((PsiElement)valueElement);
                JspElInCssInjector.doInject(registrar, (PsiLanguageInjectionHost)context, text, valueElement.getTextOffset() - context.getTextOffset() + range.getStartOffset());
            }
        } else {
            StringBuilder builder = new StringBuilder(text);
            for (PsiElement element = valueElement.getNextSibling(); element != null && element.getNode().getElementType() != CssElementTypes.CSS_RPAREN; element = element.getNextSibling()) {
                builder.append(element.getText());
            }
            text = builder.toString().trim();
            if (text.endsWith("}")) {
                JspElInCssInjector.doInject(registrar, (PsiLanguageInjectionHost)context, text, valueElement.getTextOffset() - context.getTextOffset());
            }
        }
    }

    private static void doInject(MultiHostRegistrar registrar, PsiLanguageInjectionHost context, String text, int offset) {
        TextRange from = TextRange.from((int)(offset + 2), (int)(text.length() - 3));
        registrar.startInjecting(ELLanguage.INSTANCE).addPlace(text.substring(0, 2), "}", context, from).doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<CssUri>> list = Collections.singletonList(CssUri.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/JspElInCssInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

