/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.codeinsight;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.plugins.stylus.psi.StylusVariableDeclaration;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinInvocationImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusVariableDeclarationImpl;

public class StylusRenameInputValidator
implements RenameInputValidator {
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("[@$]?([_A-Za-z][_A-Za-z0-9]*)(\\-[_A-Za-z][_A-Za-z0-9]*)*");
    private static final Pattern MIXIN_NAME_PATTERN = Pattern.compile("[.#]?([_A-Za-z][_A-Za-z0-9]*)(\\-[_A-Za-z][_A-Za-z0-9]*)*");

    public ElementPattern<? extends PsiElement> getPattern() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(StylusVariableDeclarationImpl.class), PlatformPatterns.psiElement(StylusMixinImpl.class), PlatformPatterns.psiElement(StylusMixinInvocationImpl.class)});
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        if (element instanceof StylusVariableDeclaration) {
            return VARIABLE_NAME_PATTERN.matcher(newName).matches();
        }
        return MIXIN_NAME_PATTERN.matcher(newName).matches();
    }
}

