/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.Processor;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.ChangeManagement.CCaseChangeProvider;
import net.sourceforge.transparent.ContentRevisionFactory;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NotNull;

public class VFSListener
extends VirtualFileAdapter
implements CommandListener {
    private final Project project;
    private final TransparentVcs host;
    private int commandLevel;
    private final List<VirtualFile> filesAdded = new ArrayList<VirtualFile>();
    private final List<FilePath> filesDeleted = new ArrayList<FilePath>();
    private final ChangeListManager myChangeListManager;

    public VFSListener(Project project) {
        this.project = project;
        this.host = TransparentVcs.getInstance(project);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.project);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        FileStatus status;
        VirtualFile parent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "net/sourceforge/transparent/VFSListener", "fileCreated"));
        }
        VirtualFile file = event.getFile();
        if (!VcsUtil.isFileForVcs((VirtualFile)file, (Project)this.project, (AbstractVcs)this.host)) {
            return;
        }
        this.removeFromOldLists(file);
        if (event.isFromRefresh()) {
            return;
        }
        if (this.isFileProcessable(file) && (parent = file.getParent()) != null && (status = this.myChangeListManager.getStatus(parent)) != FileStatus.UNKNOWN) {
            this.filesAdded.add(file);
        }
    }

    private void removeFromOldLists(VirtualFile file) {
        String path = file.getPath();
        this.host.removedFiles.remove(path);
        this.host.removedFolders.remove(path);
        this.host.deletedFiles.remove(path);
        this.host.deletedFolders.remove(path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toBeCreated(VirtualFileEvent event, VirtualFile newFile) {
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(newFile);
        while (!queue.isEmpty()) {
            VirtualFile file = (VirtualFile)queue.removeFirst();
            this.removeFromOldLists(file);
            if (!event.isFromRefresh()) {
                if (!this.isFileProcessable(file)) return;
                if (file.equals(newFile)) {
                    VirtualFile parent = file.getParent();
                    if (parent == null || !this.isVersioned(parent)) return;
                    this.filesAdded.add(file);
                } else {
                    this.filesAdded.add(file);
                }
            }
            queue.addAll(Arrays.asList(file.getChildren()));
        }
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "net/sourceforge/transparent/VFSListener", "beforeFileDeletion"));
        }
        try {
            if (!this.isIgnoredEvent(event)) {
                this.performDeleteFile(event.getFile());
            }
        }
        catch (ClearCaseException e) {
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException((Throwable)e), "File deletion");
        }
    }

    private void performDeleteFile(VirtualFile file) {
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(file);
        while (!queue.isEmpty()) {
            VirtualFile current = (VirtualFile)queue.removeFirst();
            this.host.deleteNewFile(current);
            queue.addAll(Arrays.asList(current.getChildren()));
        }
        Status status = this.host.getStatusSafely(file);
        if (Status.NOT_AN_ELEMENT.equals(status)) {
            return;
        }
        if (this.isFileProcessable(file)) {
            FilePath path = VcsContextFactory.SERVICE.getInstance().createFilePathOnDeleted(new File(file.getPath()), file.isDirectory());
            this.filesDeleted.add(path);
        }
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "net/sourceforge/transparent/VFSListener", "fileMoved"));
        }
        super.fileMoved(event);
        if (this.isIgnoredEvent((VirtualFileEvent)event)) {
            return;
        }
        VirtualFile file = event.getFile();
        VfsUtil.processFilesRecursively((VirtualFile)file, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if (virtualFile.isDirectory()) {
                    virtualFile.putUserData(CCaseChangeProvider.ourVersionedKey, null);
                }
                return true;
            }
        });
        if (this.wasDeleted(file)) {
            this.restore(file);
        } else if (file.getParent() != null && !this.wasMovedRenamed(file)) {
            this.toBeCreated((VirtualFileEvent)event, file);
        }
        VcsDirtyScopeManager.getInstance((Project)this.project).dirDirtyRecursively(event.getFile());
    }

    private void restore(VirtualFile file) {
        String path = file.getPath();
        if (file.isDirectory()) {
            this.host.deletedFolders.remove(path);
        } else {
            this.host.deletedFiles.remove(path);
        }
    }

    private boolean wasDeleted(VirtualFile file) {
        String path = file.getPath();
        return file.isDirectory() ? this.host.deletedFolders.contains(path) : this.host.deletedFiles.contains(path);
    }

    private boolean wasMovedRenamed(VirtualFile file) {
        if (file.isDirectory()) {
            return this.host.renamedFolders.containsKey(file.getPath());
        }
        return this.host.renamedFiles.containsKey(file.getPath());
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "net/sourceforge/transparent/VFSListener", "beforeFileMovement"));
        }
        if (this.isIgnoredEvent((VirtualFileEvent)event)) {
            return;
        }
        VirtualFile file = event.getFile();
        String oldName = file.getPath();
        String newName = event.getNewParent().getPath() + "/" + file.getName();
        if (VcsUtil.isFileForVcs((String)newName, (Project)this.project, (AbstractVcs)this.host) && this.isExistingVersioned(file) && this.isVersioned(event.getNewParent())) {
            VFSListener.storeRenameOrMoveInfo(file.isDirectory() ? this.host.renamedFolders : this.host.renamedFiles, oldName, newName);
            ContentRevisionFactory.clearCacheForFile(file.getPath());
        } else {
            this.performDeleteFile(file);
        }
    }

    private boolean isExistingVersioned(VirtualFile file) {
        return !Status.NOT_AN_ELEMENT.equals(this.host.getStatusSafely(file));
    }

    private boolean isVersioned(VirtualFile file) {
        return this.host.containsNew(file) || !Status.NOT_AN_ELEMENT.equals(this.host.getStatusSafely(file));
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        FileStatus status;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "net/sourceforge/transparent/VFSListener", "beforePropertyChange"));
        }
        VirtualFile file = event.getFile();
        if (!VcsUtil.isFileForVcs((VirtualFile)file, (Project)this.project, (AbstractVcs)this.host)) {
            return;
        }
        if (event.getPropertyName().equals("writable")) {
            file.putUserData(TransparentVcs.MERGE_CONFLICT, null);
            ContentRevisionFactory.clearCacheForFile(file.getPath());
            CCaseViewsManager viewsManager = CCaseViewsManager.getInstance(this.project);
            viewsManager.removeFileFromActivity(file.getPath());
        } else if (event.getPropertyName().equals("name") && (status = FileStatusManager.getInstance((Project)this.project).getStatus(file)) != FileStatus.ADDED && status != FileStatus.UNKNOWN && status != FileStatus.IGNORED) {
            String parentDir = file.getParent().getPath() + "/";
            String oldName = parentDir + event.getOldValue();
            String newName = parentDir + event.getNewValue();
            VFSListener.storeRenameOrMoveInfo(file.isDirectory() ? this.host.renamedFolders : this.host.renamedFiles, oldName, newName);
        }
    }

    private static void storeRenameOrMoveInfo(Map<String, String> store, String oldName, String newName) {
        String prevName = store.get(oldName);
        if (prevName == null) {
            prevName = oldName;
        }
        if (!prevName.equals(newName)) {
            store.put(newName, prevName);
        }
        store.remove(oldName);
    }

    private boolean isFileProcessable(VirtualFile file) {
        return !this.host.isFileIgnored(file) && !FileTypeManager.getInstance().isFileIgnored(file);
    }

    private boolean isIgnoredEvent(VirtualFileEvent e) {
        if (!VcsUtil.isFileForVcs((VirtualFile)e.getFile(), (Project)this.project, (AbstractVcs)this.host)) {
            return true;
        }
        return e.isFromRefresh();
    }

    public void commandStarted(CommandEvent event) {
        if (this.project == event.getProject()) {
            ++this.commandLevel;
        }
    }

    public void commandFinished(CommandEvent event) {
        if (this.project != event.getProject()) {
            return;
        }
        --this.commandLevel;
        if (!(this.commandLevel != 0 || this.filesAdded.isEmpty() && this.filesDeleted.isEmpty())) {
            ++this.commandLevel;
            try {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
            finally {
                --this.commandLevel;
            }
            if (!this.filesAdded.isEmpty()) {
                try {
                    this.executeAdd();
                }
                catch (VcsException e) {
                    AbstractVcsHelper.getInstance((Project)this.project).showError(e, "Add File failure");
                }
            }
            if (!this.filesDeleted.isEmpty()) {
                this.executeDelete();
            }
            this.reportDirty();
            this.filesAdded.clear();
            this.filesDeleted.clear();
        }
    }

    private void reportDirty() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        HashSet<VirtualFile> dirs = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : this.filesAdded) {
            if (virtualFile.isDirectory()) {
                dirs.add(virtualFile);
                continue;
            }
            files.add(virtualFile);
        }
        VcsDirtyScopeManager.getInstance((Project)this.project).filesDirty(files, dirs);
    }

    private void executeAdd() throws VcsException {
        AbstractVcsHelper helper;
        Collection filesToProcess;
        String TITLE = "Add file(s)";
        String MESSAGE = "Do you want to schedule the following file for addition to ClearCase?\n{0}";
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.filesAdded);
        VcsShowConfirmationOption confirmOption = this.host.getAddConfirmation();
        if (confirmOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(files);
        } else if (confirmOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && (filesToProcess = (helper = AbstractVcsHelper.getInstance((Project)this.project)).selectFilesToProcess(files, "Add file(s)", null, "Add file(s)", "Do you want to schedule the following file for addition to ClearCase?\n{0}", confirmOption)) != null) {
            this.performAdding(filesToProcess);
        }
    }

    private void performAdding(Collection<VirtualFile> files) throws VcsException {
        for (VirtualFile file : files) {
            String path = file.getPath();
            this.host.removedFiles.remove(path);
            this.host.removedFolders.remove(path);
            this.host.deletedFiles.remove(path);
            this.host.deletedFolders.remove(path);
            this.host.add2NewFile(file);
            VcsUtil.markFileAsDirty((Project)this.project, (VirtualFile)file);
        }
    }

    private void executeDelete() {
        String TITLE = "Delete file(s)";
        String MESSAGE = "Do you want to schedule the following file for removal from ClearCase?\n{0}";
        VcsShowConfirmationOption confirmOption = this.host.getRemoveConfirmation();
        if (confirmOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.markFileRemoval(this.filesDeleted, this.host.deletedFolders, this.host.deletedFiles);
        } else if (confirmOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            this.markFileRemoval(this.filesDeleted, this.host.removedFolders, this.host.removedFiles);
        } else {
            ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.filesDeleted);
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.project);
            Collection filesToProcess = helper.selectFilePathsToProcess(deletedFiles, "Delete file(s)", null, "Delete file(s)", "Do you want to schedule the following file for removal from ClearCase?\n{0}", confirmOption);
            if (filesToProcess != null) {
                this.markFileRemoval(filesToProcess, this.host.deletedFolders, this.host.deletedFiles);
            } else {
                this.markFileRemoval(deletedFiles, this.host.removedFolders, this.host.removedFiles);
            }
        }
    }

    private void markFileRemoval(Collection<FilePath> paths, Set<String> folders, Set<String> files) {
        ArrayList<FilePath> allpaths = new ArrayList<FilePath>(paths);
        for (FilePath fpath : allpaths) {
            String path = fpath.getPath();
            path = VcsUtil.getCanonicalLocalPath((String)path);
            if (fpath.isDirectory()) {
                this.markSubfolderStructure(path);
                folders.add(path);
            } else if (!VFSListener.isUnderDeletedFolder(this.host.removedFolders, path) && !VFSListener.isUnderDeletedFolder(this.host.deletedFolders, path)) {
                files.add(path);
            }
            VcsUtil.markFileAsDirty((Project)this.project, (FilePath)fpath);
        }
    }

    private void markSubfolderStructure(String path) {
        VFSListener.removeRecordFrom(this.host.removedFiles, path);
        VFSListener.removeRecordFrom(this.host.removedFolders, path);
        VFSListener.removeRecordFrom(this.host.deletedFiles, path);
        VFSListener.removeRecordFrom(this.host.deletedFolders, path);
    }

    private static void removeRecordFrom(Set<String> set, String path) {
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            String strFile = it.next();
            if (!strFile.startsWith(path)) continue;
            it.remove();
        }
    }

    private static boolean isUnderDeletedFolder(Set<String> folders, String path) {
        for (String folder : folders) {
            if (!path.toLowerCase().startsWith(folder.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void beforeCommandFinished(CommandEvent event) {
    }

    public void undoTransparentActionStarted() {
    }

    public void undoTransparentActionFinished() {
    }
}

