/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.codeInsight.navigation.GutterIconMultipleNavigationHandler;
import com.intellij.gwt.codeInsight.navigation.MultipleNavigationLineMarkerFactory;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PropertiesInterfaceLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final GutterIconMultipleNavigationHandler<PsiMethod> PROPERTY_GUTTER_ICON_NAVIGATION_HANDLER = new GutterIconMultipleNavigationHandler<PsiMethod>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiMethod source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("i18n.goto.property.popup.title", source.getName(), targets.size());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/PropertiesInterfaceLineMarkerProvider$1", "getPopupChooserTitle"));
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiMethod source, List<? extends GotoRelatedItem> targets) {
            return GwtBundle.message("i18n.interface.method.gutter.tooltip", targets.size());
        }
    };
    private static final GutterIconMultipleNavigationHandler<PsiClass> GUTTER_ICON_NAVIGATION_HANDLER_PROPERTIES_CLASS = new GutterIconMultipleNavigationHandler<PsiClass>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiClass source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("i18n.goto.property.popup.title", source.getName(), targets.size());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/PropertiesInterfaceLineMarkerProvider$2", "getPopupChooserTitle"));
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiClass source, List<? extends GotoRelatedItem> targets) {
            return GwtBundle.message("i18n.class.gutter.tooltip.text", targets.size());
        }
    };
    private static final Function<IProperty, PsiElement> MAPPING = iProperty -> iProperty.getPsiElement();
    private static final Function<PropertiesFile, PsiElement> PROPERTIES_FILE_PSI_ELEMENT_FUNCTION = propertiesFile -> propertiesFile.getContainingFile();

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                GwtI18nManager manager = GwtI18nManager.getInstance(method.getProject());
                Object[] properties = manager.getProperties(method);
                PsiIdentifier identifier = method.getNameIdentifier();
                if (properties.length != 0 && identifier != null) {
                    List items = GotoRelatedItem.createItems((Collection)ContainerUtil.map((Object[])properties, MAPPING));
                    result.add(MultipleNavigationLineMarkerFactory.create(method, identifier.getTextRange(), AllIcons.Gutter.ImplementedMethod, items, PROPERTY_GUTTER_ICON_NAVIGATION_HANDLER, 6));
                }
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            Object[] files = GwtI18nManager.getInstance(aClass.getProject()).getPropertiesFiles(aClass);
            PsiIdentifier identifier = aClass.getNameIdentifier();
            if (files.length == 0 || identifier == null) continue;
            List items = GotoRelatedItem.createItems((Collection)ContainerUtil.map((Object[])files, PROPERTIES_FILE_PSI_ELEMENT_FUNCTION));
            result.add(MultipleNavigationLineMarkerFactory.create(aClass, identifier.getTextRange(), AllIcons.Gutter.ImplementedMethod, items, GUTTER_ICON_NAVIGATION_HANDLER_PROPERTIES_CLASS, 6));
        }
    }
}

