/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module.model;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class CssFileConverter
extends Converter<CssFile> {
    @Nullable
    public CssFile fromString(@Nullable String path, ConvertContext context) {
        PsiFile file;
        WebDirectoryElement element;
        WebFacet webFacet;
        GwtModule gwtModule = (GwtModule)context.getInvocationElement().getParentOfType(GwtModule.class, false);
        if (gwtModule == null || path == null) {
            return null;
        }
        Collection<VirtualFile> publicRoots = gwtModule.getPublicRoots();
        for (VirtualFile root : publicRoots) {
            PsiManager psiManager;
            PsiFile psiFile;
            VirtualFile cssFile = root.findFileByRelativePath(path);
            if (cssFile == null || !((psiFile = (psiManager = context.getPsiManager()).findFile(cssFile)) instanceof CssFile)) continue;
            return (CssFile)psiFile;
        }
        GwtFacet facet = GwtFacet.getInstance(gwtModule);
        String pathFromWebRoot = path.startsWith("/") ? path : (path.startsWith("../") ? path.substring(2) : null);
        if (facet != null && facet.getSdkVersion().isHtmlFilesOutsideSourcesAreAllowed() && pathFromWebRoot != null && (webFacet = facet.getWebFacet()) != null && (element = WebUtil.getWebUtil().findWebDirectoryElement(pathFromWebRoot, webFacet)) != null && (file = element.getOriginalFile()) instanceof CssFile) {
            return (CssFile)file;
        }
        return null;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return null;
    }

    public String toString(CssFile cssFile, ConvertContext context) {
        throw new UnsupportedOperationException();
    }
}

