/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.refactorings.rename;

import com.intellij.gwt.clientBundle.ClientBundleUtil;
import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.refactorings.rename.GwtAssociatedElementRenameHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.css.CssFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodForCssClassRenameHandler
extends GwtAssociatedElementRenameHandler<PsiMethod> {
    public MethodForCssClassRenameHandler() {
        super(PsiMethod.class);
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> findAssociatedElements(@NotNull PsiMethod baseElement) {
        if (baseElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseElement", "com/intellij/gwt/refactorings/rename/MethodForCssClassRenameHandler", "findAssociatedElements"));
        }
        PsiClass psiClass = baseElement.getContainingClass();
        if (psiClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/rename/MethodForCssClassRenameHandler", "findAssociatedElements"));
            }
            return list;
        }
        Set<CssFile> files = ClientBundleUtil.getCssFiles(psiClass, true, true);
        if (files.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/rename/MethodForCssClassRenameHandler", "findAssociatedElements"));
            }
            return list;
        }
        String name = baseElement.getName();
        SmartList result = new SmartList();
        for (CssFile file : files) {
            result.addAll(GwtCssDeclarationsManager.findDeclarations(file, name));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/refactorings/rename/MethodForCssClassRenameHandler", "findAssociatedElements"));
        }
        return smartList;
    }
}

