/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.gwt.run.GwtCommandLineState;
import com.intellij.gwt.run.HostedModeWarDirectoryGenerator;
import com.intellij.gwt.run.remoteUi.RemoteUiConnection;
import com.intellij.javaee.run.execution.update.RunningApplicationUpdater;
import com.intellij.javaee.run.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.GwtStudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DevModeUpdaterProvider
extends RunningApplicationUpdaterProvider {
    public RunningApplicationUpdater createUpdater(@NotNull Project project, @NotNull ProcessHandler process) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/run/DevModeUpdaterProvider", "createUpdater"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/gwt/run/DevModeUpdaterProvider", "createUpdater"));
        }
        HostedModeWarDirectoryGenerator devModeGenerator = (HostedModeWarDirectoryGenerator)process.getUserData(GwtCommandLineState.GWT_GENERATOR_KEY);
        GwtCommandLineState state = (GwtCommandLineState)((Object)process.getUserData(GwtCommandLineState.GWT_CONFIGURATION_STATE_KEY));
        if (devModeGenerator != null && state != null) {
            return new DevModeUpdater(project, devModeGenerator, state);
        }
        return null;
    }

    private static class DevModeUpdater
    extends RunningApplicationUpdater {
        private final Project myProject;
        private final HostedModeWarDirectoryGenerator myDevModeGenerator;
        private final GwtCommandLineState myConfigurationState;

        public DevModeUpdater(Project project, HostedModeWarDirectoryGenerator devModeGenerator, GwtCommandLineState state) {
            this.myProject = project;
            this.myDevModeGenerator = devModeGenerator;
            this.myConfigurationState = state;
        }

        public String getDescription() {
            return "Update '" + this.myConfigurationState.getRunConfigurationName() + "'";
        }

        public String getShortName() {
            return this.myConfigurationState.getRunConfigurationName();
        }

        public Icon getIcon() {
            return GwtStudioIcons.Google_small;
        }

        public void performUpdate() {
            this.myDevModeGenerator.updateResources(this.myProject, this.myConfigurationState.getRunConfigurationName());
            new Task.Backgroundable(this.myProject, "Looking for Changed Classes...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/gwt/run/DevModeUpdaterProvider$DevModeUpdater$1", "run"));
                    }
                    ModuleCompileScope scope = new ModuleCompileScope(myConfigurationState.getModule(), false);
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                    if (!compilerManager.isUpToDate((CompileScope)scope)) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            String message = "Some java classes were changed. Do you want to restart the GWT Dev Mode server?";
                            if (Messages.showYesNoDialog((Project)this.myProject, (String)"Some java classes were changed. Do you want to restart the GWT Dev Mode server?", (String)this.getDescription(), null) == 0) {
                                compilerManager.make(myConfigurationState.getModule(), new CompileStatusNotification(){

                                    public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                                        RemoteUiConnection connection = myConfigurationState.getUiConnection();
                                        if (!aborted && errors == 0 && connection != null) {
                                            myDevModeGenerator.updateResources(myProject, null);
                                            connection.sendRestartServerRequest();
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            }.queue();
        }
    }
}

