/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.HostedModeWarDirectoryGenerator;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GwtCommandLineStateBase
extends JavaCommandLineState {
    protected final Module myModule;
    protected final String myVMParameters;
    protected final GwtFacet myFacet;
    protected final String myShellParameters;
    private final List<String> myGwtModules;
    protected final Executor myExecutor;
    protected final GwtRunConfiguration.GwtRunConfigurationState myState;

    public GwtCommandLineStateBase(ExecutionEnvironment environment, @NotNull Executor executor, GwtFacet facet, GwtRunConfiguration.GwtRunConfigurationState state) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/gwt/run/GwtCommandLineStateBase", "<init>"));
        }
        super(environment);
        this.myFacet = facet;
        this.myModule = this.myFacet.getModule();
        this.myGwtModules = state.getGwtModules();
        this.myExecutor = executor;
        this.myShellParameters = state.SHELL_PARAMETERS;
        this.myVMParameters = state.VM_PARAMETERS;
        this.myState = state;
    }

    public Module getModule() {
        return this.myModule;
    }

    protected HostedModeWarDirectoryGenerator createDevModeWarDirectoryGenerator(File warDirectory, File cacheFile) {
        HostedModeWarDirectoryGenerator generator = new HostedModeWarDirectoryGenerator(warDirectory, cacheFile);
        ArrayList webFacets = new ArrayList();
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)this.myModule).withoutSdk().productionOnly().runtimeOnly().recursively();
        enumerator.forEachModule(module -> {
            GwtFacet facet = GwtFacet.getInstance(module);
            if (facet != null) {
                ContainerUtil.addIfNotNull((Collection)webFacets, (Object)facet.getWebFacet());
            } else {
                webFacets.addAll(WebFacet.getInstances((Module)module));
            }
            return true;
        });
        for (WebFacet webFacet : webFacets) {
            for (WebRoot webRoot : webFacet.getWebRoots()) {
                VirtualFile dir = webRoot.getFile();
                if (dir == null) continue;
                generator.addFile(dir, webRoot.getRelativePath());
            }
        }
        PathsList classpath = enumerator.getPathsList();
        VirtualFile gwtUserJar = ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk().getUserJar();
        boolean gwtServletJarFound = false;
        String servletJarPath = FileUtil.toSystemIndependentName((String)((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk().getServletJarPath());
        VirtualFile gwtServletJar = LocalFileSystem.getInstance().findFileByPath(servletJarPath);
        for (VirtualFile file : classpath.getVirtualFiles()) {
            if (file.isDirectory()) {
                generator.addFile(file, "WEB-INF/classes");
                continue;
            }
            if (gwtUserJar != null && gwtUserJar.equals(file)) continue;
            generator.addFile(file, "WEB-INF/lib/" + file.getName());
            if (!file.equals(gwtServletJar)) continue;
            gwtServletJarFound = true;
        }
        if (!gwtServletJarFound && gwtServletJar != null) {
            generator.addFile(gwtServletJar, "WEB-INF/lib/" + gwtServletJar.getName());
        }
        return generator;
    }

    protected void addGwtModules(ParametersList programParameters) {
        if (this.myGwtModules != null) {
            programParameters.addAll(this.myGwtModules);
        } else {
            for (GwtModule module : GwtModulesManager.getInstance(this.myModule.getProject()).getCompilableGwtModules(this.myModule, false)) {
                programParameters.add(module.getQualifiedName());
            }
        }
    }

    protected Collection<GwtModule> getGwtModules() {
        GwtModulesManager modulesManager = GwtModulesManager.getInstance(this.myModule.getProject());
        if (this.myGwtModules != null) {
            ArrayList<GwtModule> modules = new ArrayList<GwtModule>();
            for (String module : this.myGwtModules) {
                ContainerUtil.addIfNotNull(modules, (Object)modulesManager.findGwtModuleByQualifiedName(module, this.myModule.getModuleScope(false)));
            }
            return modules;
        }
        return modulesManager.getCompilableGwtModules(this.myModule, false);
    }

    protected static boolean containsUserJar(PathsList classPath) {
        for (String path : classPath.getPathList()) {
            String name = PathUtil.getFileName((String)path);
            if (!name.startsWith("gwt-user") || !name.endsWith(".jar")) continue;
            return true;
        }
        return false;
    }
}

