/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.superSource;

import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtSuperSourceClassCacheImpl
extends GwtSuperSourceClassCache {
    private final Project myProject;

    public GwtSuperSourceClassCacheImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public List<PsiClass> findClassesByQualifiedName(@NotNull String qualifiedName, @NotNull VirtualFile root) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "findClassesByQualifiedName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "findClassesByQualifiedName"));
        }
        SmartList result = new SmartList();
        SmartList innerClassNames = new SmartList();
        String currentName = qualifiedName;
        do {
            PsiFile psiFile;
            VirtualFile file;
            if ((file = root.findFileByRelativePath(currentName.replace('.', '/') + ".java")) != null && (psiFile = this.getCachedPsiFile(file)) instanceof PsiJavaFile) {
                for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!currentName.equals(aClass.getQualifiedName())) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)GwtSuperSourceClassCacheImpl.findInnerClass(aClass, (List<String>)innerClassNames));
                }
            }
            innerClassNames.add(StringUtil.getShortName((String)currentName));
        } while ((currentName = StringUtil.getPackageName((String)currentName)).length() > 0);
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/superSource/GwtSuperSourceClassCacheImpl", "findClassesByQualifiedName"));
        }
        return smartList;
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(VirtualFile file) {
        return PsiManager.getInstance((Project)this.myProject).findFile(file);
    }

    @Nullable
    static PsiClass findInnerClass(PsiClass topLevelClass, List<String> names) {
        String name;
        PsiClass current = topLevelClass;
        for (int i = names.size() - 1; i >= 0 && current != null; current = current.findInnerClassByName(name, false), --i) {
            name = names.get(i);
        }
        return current;
    }
}

