/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.references.GwtUiReferenceContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class GwtUiXmlNamespaceCompletionContributor
extends CompletionContributor {
    public static final ElementPattern<? extends PsiElement> XMLNS_VALUE_PATTERN = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue((ElementPattern)XmlPatterns.xmlAttribute().withName(StandardPatterns.or((ElementPattern[])new ElementPattern[]{StandardPatterns.string().longerThan(6).startsWith("xmlns:"), StandardPatterns.string().matches("xmlns")}))))).inFile(GwtUiReferenceContributor.UI_XML_FILE_PATTERN);

    public GwtUiXmlNamespaceCompletionContributor() {
        this.extend(CompletionType.BASIC, XMLNS_VALUE_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor$1", "addCompletions"));
                }
                String prefix = result.getPrefixMatcher().getPrefix();
                if (!prefix.startsWith("urn:import:")) {
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"urn:import:").withInsertHandler((insertionContext, item) -> {
                        if (insertionContext.getCompletionChar() == '\t') {
                            AutoPopupController.getInstance((Project)insertionContext.getProject()).scheduleAutoPopup(insertionContext.getEditor());
                        }
                    }), (double)100.0));
                } else {
                    int lastDotIndex;
                    String packageName;
                    PsiPackage psiPackage;
                    PsiElement position = parameters.getPosition();
                    Project project = position.getProject();
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)position);
                    GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)project) : module.getModuleWithDependenciesAndLibrariesScope(true);
                    String fullPackageName = prefix.substring("urn:import:".length());
                    PsiPackage fullPsiPackage = psiFacade.findPackage(fullPackageName);
                    if (fullPsiPackage != null) {
                        for (PsiPackage subPackage : fullPsiPackage.getSubPackages(scope)) {
                            this.addResult(result, fullPackageName, subPackage.getQualifiedName(), -100.0);
                        }
                    }
                    if ((psiPackage = psiFacade.findPackage(packageName = (lastDotIndex = fullPackageName.lastIndexOf(46)) == -1 ? "" : fullPackageName.substring(0, lastDotIndex))) != null) {
                        for (PsiPackage subPackage : psiPackage.getSubPackages(scope)) {
                            this.addResult(result, packageName, subPackage.getQualifiedName(), 0.0);
                        }
                    }
                }
            }

            private void addResult(@NotNull CompletionResultSet result, @NotNull String packageName, @NotNull String subPackageName, double priority) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor$1", "addResult"));
                }
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor$1", "addResult"));
                }
                if (subPackageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPackageName", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor$1", "addResult"));
                }
                if ((subPackageName = subPackageName.trim()).startsWith(packageName)) {
                    int startIndex;
                    int n = startIndex = packageName.isEmpty() ? 0 : packageName.length() + 1;
                    if (subPackageName.indexOf(46, startIndex) < 0) {
                        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)("urn:import:" + subPackageName)), (double)priority));
                    }
                }
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        int dotIndex;
        int elementTextOffset;
        int offsetInElement;
        int contextStartOffset;
        PsiElement element;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor", "beforeCompletion"));
        }
        super.beforeCompletion(context);
        PsiFile file = context.getFile();
        if (file instanceof XmlFile && UiBinderUtil.isUiXmlFile((XmlFile)file) && (element = file.findElementAt(contextStartOffset = context.getStartOffset())) != null && XMLNS_VALUE_PATTERN.accepts((Object)element) && (offsetInElement = contextStartOffset - (elementTextOffset = element.getTextRange().getStartOffset())) >= "urn:import:".length() && (dotIndex = element.getText().indexOf(46, offsetInElement)) != -1) {
            context.setReplacementOffset(elementTextOffset + dotIndex);
        }
    }

    public static boolean invokeNamespaceAutoPopup(char typeChar) {
        return typeChar == '.' || typeChar == ':';
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/gwt/uiBinder/GwtUiXmlNamespaceCompletionContributor", "invokeAutoPopup"));
        }
        return GwtUiXmlNamespaceCompletionContributor.invokeNamespaceAutoPopup(typeChar);
    }
}

