/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.remote.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.jpa.remote.GroovyHelper;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.remote.RemoteQueryResult;
import com.intellij.jpa.remote.impl.QueryResult;
import com.intellij.jpa.remote.impl.QueryResultImpl;
import com.intellij.jpa.remote.impl.RemoteQueryResultImpl;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class RemoteQueryImpl
extends JdbcRemoteObject
implements RemoteQuery {
    private final Query myDelegate;
    private final Session mySession;
    private int myUpdateCount;
    private boolean myResultFlag;

    protected RemoteQueryImpl(Query delegate, Session session) {
        this.myDelegate = delegate;
        this.mySession = session;
    }

    public static RemoteQueryImpl wrap(Query delegate, Session session) {
        return new RemoteQueryImpl(delegate, session);
    }

    public Query getDelegate() {
        return this.myDelegate;
    }

    public Session getSession() {
        return this.mySession;
    }

    public void setParameter(String p1, Object p2) throws RemoteException {
        try {
            this.myDelegate.setParameter(p1, GroovyHelper.makeParameter((Object)p2));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void setParameter(int p1, Object p2) throws RemoteException {
        try {
            this.myDelegate.setParameter(p1, GroovyHelper.makeParameter((Object)p2));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public boolean execute() throws RemoteException {
        try {
            this.myUpdateCount = 0;
            String query = this.myDelegate.getQueryString();
            query = query == null ? null : query.trim().toUpperCase();
            boolean bl = this.myResultFlag = query != null && !query.startsWith("UPDATE") && !query.startsWith("DELETE") && !query.startsWith("INSERT");
            if (this.myResultFlag) {
                this.myUpdateCount = 0;
            } else {
                Transaction tx = this.mySession.beginTransaction();
                try {
                    this.myUpdateCount = this.myDelegate.executeUpdate();
                }
                finally {
                    tx.commit();
                }
            }
            return this.myResultFlag;
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public int getUpdateCount() throws RemoteException {
        return this.myUpdateCount;
    }

    public RemoteQueryResult getQueryResult() throws RemoteException {
        if (!this.myResultFlag) {
            return null;
        }
        try {
            return (RemoteQueryResult)this.export((Remote)RemoteQueryResultImpl.wrap((QueryResult)this.createQueryResult()));
        }
        catch (RemoteException e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    protected QueryResult createQueryResult() {
        return new QueryResultImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Object> getResultList() {
                RemoteQueryImpl.this.mySession.clear();
                Transaction tx = RemoteQueryImpl.this.mySession.beginTransaction();
                try {
                    List list = RemoteQueryImpl.this.getDelegate().list();
                    return list;
                }
                finally {
                    try {
                        tx.commit();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    public void close() throws RemoteException {
        this.unreferenced();
    }
}

