/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.config;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.UI.config.CfmlMappingsForm;
import com.intellij.coldFusion.UI.config.CfmlProjectConfiguration;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FileContentUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CfmlProjectConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private CfmlMappingsForm myForm;

    public CfmlProjectConfigurable(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/config/CfmlProjectConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "ColdFusion";
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.plugin.settings.project.settings.cfml" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/config/CfmlProjectConfigurable", "getHelpTopic"));
        }
        return "reference.plugin.settings.project.settings.cfml";
    }

    public JComponent createComponent() {
        this.myForm = new CfmlMappingsForm(this.myProject);
        return this.myForm.getContentPane();
    }

    public boolean isModified() {
        CfmlProjectConfiguration.State originalState = CfmlProjectConfiguration.getInstance(this.myProject).getState();
        CfmlProjectConfiguration.State currentState = new CfmlProjectConfiguration.State();
        this.myForm.applyTo(currentState);
        return !currentState.equals(originalState);
    }

    public void apply() throws ConfigurationException {
        CfmlProjectConfiguration.State currentState = new CfmlProjectConfiguration.State();
        this.myForm.applyTo(currentState);
        CfmlProjectConfiguration.getInstance(this.myProject).loadState(currentState);
        CfmlProjectConfigurable.storeLanguageVersionWithProgress(this.myProject);
    }

    public void reset() {
        this.myForm.reset(CfmlProjectConfiguration.getInstance(this.myProject).getState());
    }

    public void disposeUIResources() {
        this.myForm = null;
    }

    public static void storeLanguageVersionWithProgress(final Project project) {
        Task.Backgroundable task = new Task.Backgroundable(project, CfmlBundle.message("applying.new.language.version.task.name", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coldFusion/UI/config/CfmlProjectConfigurable$1", "run"));
                }
                final ArrayList cfmlFiles = new ArrayList();
                VirtualFile baseDir = project.getBaseDir();
                if (baseDir != null) {
                    FileBasedIndex.getInstance().iterateIndexableFiles(new ContentIterator(){

                        public boolean processFile(VirtualFile file) {
                            if (CfmlFileType.INSTANCE == file.getFileType()) {
                                cfmlFiles.add(file);
                            }
                            return true;
                        }
                    }, project, indicator);
                }
                ApplicationManager.getApplication().invokeAndWait(() -> FileContentUtil.reparseFiles((Project)project, (Collection)cfmlFiles, (boolean)true), ModalityState.NON_MODAL);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }
}

