/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.info.CfmlLangInfo;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlArgumentList;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlParameterInfoHandler
implements ParameterInfoHandler<PsiElement, CfmlFunctionDescription> {
    private String myText;

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        Object o = item.getObject();
        if (o instanceof PsiElement) {
            PsiElement element = (PsiElement)o;
            ArrayList<PsiElement> methods = new ArrayList<PsiElement>();
            if (element instanceof CfmlFunction || element instanceof PsiMethod) {
                methods.add(element);
            }
            return ArrayUtil.toObjectArray(methods);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public Object[] getParametersForDocumentation(CfmlFunctionDescription p, ParameterInfoContext context) {
        return ArrayUtil.toObjectArray(p.getParameters());
    }

    private static boolean isEmbraced(@Nullable PsiElement element, int offset) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        ASTNode lbrace = node.findChildByType(CfscriptTokenTypes.L_BRACKET);
        ASTNode rbrace = node.findChildByType(CfscriptTokenTypes.R_BRACKET);
        if (lbrace == null || rbrace == null) {
            return false;
        }
        return lbrace.getStartOffset() < offset && rbrace.getStartOffset() >= offset;
    }

    @Nullable
    private static PsiElement findAnchorElement(int offset, PsiFile file) {
        if (offset <= 0) {
            return null;
        }
        if (file instanceof CfmlFile) {
            CfmlArgumentList parametersList = (CfmlArgumentList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, CfmlArgumentList.class, (boolean)false);
            if (parametersList == null) {
                return null;
            }
            if (CfmlParameterInfoHandler.isEmbraced(parametersList, offset)) {
                PsiElement element = parametersList.getParent();
                return element instanceof CfmlFunctionCallExpression ? ((CfmlFunctionCallExpression)element).getReferenceExpression() : element;
            }
        }
        return null;
    }

    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "findElementForParameterInfo"));
        }
        return CfmlParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return CfmlParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "showParameterInfo"));
        }
        Object[] variants = ResolveResult.EMPTY_ARRAY;
        if (element instanceof PsiPolyVariantReference && (variants = ((PsiPolyVariantReference)element).multiResolve(true)).length != 0) {
            context.setItemsToShow(ContainerUtil.map2Array((Object[])variants, CfmlFunctionDescription.class, resolveResult -> {
                PsiElement element1 = resolveResult.getElement();
                if (CfmlPsiUtil.isFunctionDefinition(element1)) {
                    CfmlFunction function = CfmlPsiUtil.getFunctionDefinition(element1);
                    if (function != null) {
                        return function.getFunctionInfo();
                    }
                } else if (element1 instanceof PsiMethod) {
                    PsiMethod function = (PsiMethod)element1;
                    CfmlFunctionDescription javaMethodDescr = new CfmlFunctionDescription(function.getName(), function.getReturnType().getPresentableText());
                    for (PsiParameter psiParameter : function.getParameterList().getParameters()) {
                        javaMethodDescr.addParameter(new CfmlFunctionDescription.CfmlParameterDescription(psiParameter.getName(), psiParameter.getType().getPresentableText(), true));
                    }
                    return javaMethodDescr;
                }
                return null;
            }));
            context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
            return;
        }
        if (element instanceof CfmlReferenceExpression) {
            String functionName = element.getText().toLowerCase();
            if (ArrayUtil.find((Object[])CfmlLangInfo.getInstance(element.getProject()).getPredefinedFunctionsLowCase(), (Object)functionName) != -1) {
                context.setItemsToShow(new Object[]{CfmlLangInfo.getInstance(element.getProject()).getFunctionParameters().get(functionName)});
                context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
            }
        }
    }

    public void updateParameterInfo(@NotNull PsiElement place, @NotNull UpdateParameterInfoContext context) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() == null) {
            context.setParameterOwner(place);
        } else if (!context.getParameterOwner().equals(place)) {
            context.removeHint();
            return;
        }
        Object[] objects = context.getObjectsToView();
        for (int i = 0; i < objects.length; ++i) {
            context.setUIComponentEnabled(i, true);
        }
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    public void updateUI(CfmlFunctionDescription p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/CfmlParameterInfoHandler", "updateUI"));
        }
        if (p == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        this.myText = p.getParametersListPresentableText();
        context.setupUIComponentPresentation(this.myText, 0, 0, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    public String getText() {
        return this.myText;
    }
}

