/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.highlighting;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.model.lexer.CfmlLexer;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.ide.highlighter.custom.CustomHighlighterColors;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlFileType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlHighlighter
extends LayeredLexerEditorHighlighter {
    public CfmlHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/coldFusion/UI/highlighting/CfmlHighlighter", "<init>"));
        }
        super((SyntaxHighlighter)new CfmlFileHighlighter(project), colors);
        this.registerLayer(CfmlElementTypes.TEMPLATE_TEXT, new LayerDescriptor(SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.HTML, (Project)project, (VirtualFile)virtualFile), ""));
        this.registerLayer(CfmlElementTypes.SQL, new LayerDescriptor(SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)SqlFileType.INSTANCE, (Project)project, (VirtualFile)virtualFile), ""));
    }

    static class CfmlFileHighlighter
    extends SyntaxHighlighterBase {
        private static Map<IElementType, TextAttributesKey> keys2;
        private Project myProject;
        static final TextAttributesKey CFML_ATTRIBUTE;
        static final TextAttributesKey CFML_COMMENT;
        static final TextAttributesKey CFML_TAG_NAME;
        static final TextAttributesKey CFML_BRACKETS;
        static final TextAttributesKey CFML_OPERATOR;
        static final TextAttributesKey CFML_STRING;
        static final TextAttributesKey CFML_NUMBER;
        static final TextAttributesKey CFML_IDENTIFIER;
        static final TextAttributesKey CFML_BAD_CHARACTER;
        static final TextAttributesKey CFML_SHARP;
        static final TextAttributesKey CFML_KEYWORD;

        CfmlFileHighlighter(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            CfmlLexer cfmlLexer = new CfmlLexer(true, this.myProject);
            if (cfmlLexer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/highlighting/CfmlHighlighter$CfmlFileHighlighter", "getHighlightingLexer"));
            }
            return cfmlLexer;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray = CfmlFileHighlighter.pack((TextAttributesKey)keys2.get(tokenType));
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/highlighting/CfmlHighlighter$CfmlFileHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }

        static {
            CFML_ATTRIBUTE = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.attribute", new Object[0]), (TextAttributesKey)CustomHighlighterColors.CUSTOM_KEYWORD2_ATTRIBUTES);
            CFML_COMMENT = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.comment", new Object[0]), (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
            CFML_TAG_NAME = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.tag.name", new Object[0]), (TextAttributesKey)XmlHighlighterColors.HTML_TAG_NAME);
            CFML_BRACKETS = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.bracket", new Object[0]), (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
            CFML_OPERATOR = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.operator", new Object[0]), (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
            CFML_STRING = TextAttributesKey.createTextAttributesKey((String)("Cfml" + CfmlBundle.message("cfml.string", new Object[0])), (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
            CFML_NUMBER = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.number", new Object[0]), (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
            CFML_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.identifier", new Object[0]), (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
            CFML_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.badcharacter", new Object[0]), (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
            CFML_SHARP = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.sharp", new Object[0]), (TextAttributesKey)CustomHighlighterColors.CUSTOM_KEYWORD2_ATTRIBUTES);
            CFML_KEYWORD = TextAttributesKey.createTextAttributesKey((String)CfmlBundle.message("cfml.keyword", new Object[0]), (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
            keys2 = new HashMap<IElementType, TextAttributesKey>();
            CfmlFileHighlighter.fillMap(keys2, (TokenSet)CfmlTokenTypes.BRACKETS, (TextAttributesKey)CFML_BRACKETS);
            CfmlFileHighlighter.fillMap(keys2, (TokenSet)CfmlTokenTypes.STRING_ELEMENTS, (TextAttributesKey)CFML_STRING);
            keys2.put(CfmlTokenTypes.ASSIGN, CFML_OPERATOR);
            keys2.put(CfmlTokenTypes.START_EXPRESSION, CFML_SHARP);
            keys2.put(CfmlTokenTypes.CF_TAG_NAME, CFML_TAG_NAME);
            keys2.put(CfmlTokenTypes.ATTRIBUTE, CFML_ATTRIBUTE);
            keys2.put(CfmlTokenTypes.END_EXPRESSION, CFML_SHARP);
            keys2.put(CfmlTokenTypes.COMMENT, CFML_COMMENT);
            keys2.put(CfmlTokenTypes.VAR_ANNOTATION, CFML_COMMENT);
            CfmlFileHighlighter.fillMap(keys2, (TokenSet)CfscriptTokenTypes.OPERATIONS, (TextAttributesKey)CFML_OPERATOR);
            CfmlFileHighlighter.fillMap(keys2, (TokenSet)CfscriptTokenTypes.BRACKETS, (TextAttributesKey)CFML_BRACKETS);
            CfmlFileHighlighter.fillMap(keys2, (TokenSet)CfscriptTokenTypes.WORD_OPERATIONS, (TextAttributesKey)CFML_KEYWORD);
            CfmlFileHighlighter.fillMap(keys2, (TokenSet)CfscriptTokenTypes.KEYWORDS, (TextAttributesKey)CFML_KEYWORD);
            keys2.put(CfscriptTokenTypes.INTEGER, CFML_NUMBER);
            keys2.put(CfscriptTokenTypes.DOUBLE, CFML_NUMBER);
            keys2.put(CfscriptTokenTypes.COMMENT, CFML_COMMENT);
            keys2.put(CfscriptTokenTypes.IDENTIFIER, CFML_IDENTIFIER);
            keys2.put(CfscriptTokenTypes.BAD_CHARACTER, CFML_BAD_CHARACTER);
            keys2.put(CfscriptTokenTypes.OPENSHARP, CFML_SHARP);
            keys2.put(CfscriptTokenTypes.CLOSESHARP, CFML_SHARP);
        }
    }
}

