/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedAttributeImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlTagImpl
extends CfmlCompositeElement
implements CfmlTag {
    public CfmlTagImpl(ASTNode astNode) {
        super(astNode);
    }

    public CfmlTagImpl(@NotNull NamedStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "processDeclarations"));
        }
        return CfmlPsiUtil.processDeclarations(processor, state, lastParent, this);
    }

    @Override
    @NotNull
    public String getTagName() {
        PsiElement pe = this.findChildByType(CfmlTokenTypes.CF_TAG_NAME);
        String string = pe == null ? "" : pe.getText().toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "getTagName"));
        }
        return string;
    }

    public String getName() {
        return this.getTagName();
    }

    @Nullable
    public PsiNamedElement getDeclarativeElement() {
        if ("cfset".equals(this.getName())) {
            CfmlAssignmentExpression assignment = (CfmlAssignmentExpression)this.findChildByClass(CfmlAssignmentExpression.class);
            return assignment != null ? assignment.getAssignedVariable() : null;
        }
        return (PsiNamedElement)this.findChildByClass(CfmlNamedAttributeImpl.class);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        Couple<String> prefixAndName = CfmlUtil.getPrefixAndName(this.getName());
        String componentName = (String)prefixAndName.getSecond();
        CfmlImport cfmlImport = CfmlUtil.getImportByPrefix(this, (String)prefixAndName.getFirst());
        PsiElement tagName = this.findChildByType(CfmlTokenTypes.CF_TAG_NAME);
        if (tagName != null && cfmlImport != null && !StringUtil.isEmpty((String)componentName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new CfmlComponentReference(tagName.getNode())};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "getReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public PsiElement getAttributeValueElement(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/coldFusion/model/psi/impl/CfmlTagImpl", "getAttributeValueElement"));
        }
        return CfmlPsiUtil.getAttributeValueElement(this, attributeName);
    }
}

