/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.psi.impl.JSPropertyReference;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexPropertiesSupport {
    private static final BundleNameEvaluator MY_BUNDLE_NAME_EVALUATOR = new BundleNameEvaluator(){

        public String evaluateBundleName(PsiFile psiFile) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getOriginalFile().getVirtualFile();
            if (virtualFile != null && psiFile instanceof PropertiesFile) {
                return virtualFile.getNameWithoutExtension();
            }
            return null;
        }
    };

    public static <T extends PsiElement> PsiReference[] getPropertyReferences(T element, PropertyReferenceInfoProvider<T> infoProvider) {
        TextRange range = infoProvider.getReferenceRange(element);
        if (range == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new MyPropertyReference<T>(range, element, infoProvider)};
    }

    public static <T extends PsiElement> PsiReference[] getResourceBundleReference(T element, BundleReferenceInfoProvider<T> infoProvider) {
        final TextRange textRange = infoProvider.getReferenceRange(element);
        if (textRange == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new MyResourceBundleReference(element, infoProvider.isSoft(element)){

            protected TextRange calculateDefaultRangeInElement() {
                return textRange;
            }
        }};
    }

    private static class MyResourceBundleReference
    extends ResourceBundleReference
    implements EmptyResolveMessageProvider {
        public MyResourceBundleReference(PsiElement element, boolean soft) {
            super(element, soft);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Cannot resolve property bundle" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexPropertiesSupport$MyResourceBundleReference", "getUnresolvedMessagePattern"));
            }
            return "Cannot resolve property bundle";
        }

        @Nullable
        public String evaluateBundleName(PsiFile psiFile) {
            return MY_BUNDLE_NAME_EVALUATOR.evaluateBundleName(psiFile);
        }
    }

    private static class MyPropertyReference<T extends PsiElement>
    extends PropertyReference
    implements JSPropertyReference {
        public MyPropertyReference(TextRange range, T element, PropertyReferenceInfoProvider<T> infoProvider) {
            super(range.substring(element.getText()), element, infoProvider.getBundleName(element), infoProvider.isSoft(element), range);
        }

        protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
            return PropertiesReferenceManager.getInstance((Project)element.getProject()).findPropertiesFiles(element.getResolveScope(), bundleName, MY_BUNDLE_NAME_EVALUATOR);
        }
    }

    public static interface BundleReferenceInfoProvider<T> {
        @Nullable
        public TextRange getReferenceRange(T var1);

        public boolean isSoft(T var1);
    }

    public static interface PropertyReferenceInfoProvider<T> {
        @Nullable
        public TextRange getReferenceRange(T var1);

        @Nullable
        public String getBundleName(T var1);

        public boolean isSoft(T var1);
    }
}

