/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.compiled;

import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.annotations.NotNull;

public class SwfFileViewProviderFactory
implements FileViewProviderFactory {
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory", "createFileViewProvider"));
        }
        SwfFileViewProvider swfFileViewProvider = new SwfFileViewProvider(manager, file, eventSystemEnabled);
        if (swfFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory", "createFileViewProvider"));
        }
        return swfFileViewProvider;
    }

    static class CompiledJSFile
    extends JSFileImpl
    implements PsiCompiledFile {
        public CompiledJSFile(FileViewProvider fileViewProvider) {
            super(fileViewProvider);
        }

        public PsiElement getMirror() {
            return this;
        }

        public boolean isWritable() {
            return true;
        }

        public PsiFile getDecompiledPsiFile() {
            return this;
        }
    }

    private static class SwfFileViewProvider
    extends SingleRootFileViewProvider {
        public SwfFileViewProvider(PsiManager manager, VirtualFile file, boolean physical) {
            super(manager, file, physical);
        }

        protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile vFile, @NotNull FileType fileType) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory$SwfFileViewProvider", "createFile"));
            }
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory$SwfFileViewProvider", "createFile"));
            }
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory$SwfFileViewProvider", "createFile"));
            }
            return new CompiledJSFile((FileViewProvider)this);
        }

        @NotNull
        public Language getBaseLanguage() {
            Language language = FlexApplicationComponent.DECOMPILED_SWF;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory$SwfFileViewProvider", "getBaseLanguage"));
            }
            return language;
        }

        @NotNull
        public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
            if (copy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory$SwfFileViewProvider", "createCopy"));
            }
            SwfFileViewProvider swfFileViewProvider = new SwfFileViewProvider(this.getManager(), copy, false);
            if (swfFileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/compiled/SwfFileViewProviderFactory$SwfFileViewProvider", "createCopy"));
            }
            return swfFileViewProvider;
        }
    }
}

