/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssElementDescriptorProvider;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.xml.util.ColorMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlexCssValueValidator
extends CssValueValidatorImpl {
    public FlexCssValueValidator(@NotNull FlexCssElementDescriptorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/javascript/flex/css/FlexCssValueValidator", "<init>"));
        }
        super((CssElementDescriptorProvider)provider);
    }

    public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/javascript/flex/css/FlexCssValueValidator", "isValid"));
        }
        if (valueDescriptor instanceof CssColorValue) {
            return term != null && FlexCssValueValidator.isValidColor(term);
        }
        if (valueDescriptor instanceof CssStringValue) {
            return term != null && FlexCssValueValidator.isValidString(term) && super.isValid(term, valueDescriptor);
        }
        if (valueDescriptor instanceof CssLengthValue) {
            return term != null && term instanceof CssTerm && (super.isValid(term, valueDescriptor) || FlexCssValueValidator.isValidLength((CssTerm)term));
        }
        return super.isValid(term, valueDescriptor);
    }

    private static boolean isValidString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/FlexCssValueValidator", "isValidString"));
        }
        return FlexCssUtil.inQuotes(element.getText().trim());
    }

    private static boolean isValidLength(@NotNull CssTerm cssTerm) {
        if (cssTerm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssTerm", "com/intellij/javascript/flex/css/FlexCssValueValidator", "isValidLength"));
        }
        CssTermType termType = cssTerm.getTermType();
        return termType == CssTermTypes.NEGATIVE_NUMBER || termType == CssTermTypes.NUMBER || termType == CssTermTypes.INTEGER;
    }

    private static boolean isValidColor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/FlexCssValueValidator", "isValidColor"));
        }
        String text = element.getText().trim();
        if (FlexCssValueValidator.isInteger(text)) {
            return true;
        }
        if (!(element instanceof CssTerm) || ((CssTerm)element).getTermType() != CssTermTypes.COLOR) {
            if (FlexCssUtil.inQuotes(text)) {
                if ((text = StringUtil.unquoteString((String)text, (char)'\"')).startsWith("0x")) {
                    return FlexCssValueValidator.isInteger(text.substring(2));
                }
                if (FlexCssValueValidator.containsOnlyLetters(text)) {
                    return ColorMap.isStandardColor((String)text.toLowerCase(Locale.US));
                }
            }
            return false;
        }
        if (FlexCssValueValidator.containsOnlyLetters(text)) {
            return ColorMap.isStandardColor((String)text.toLowerCase(Locale.US));
        }
        return true;
    }

    private static boolean containsOnlyLetters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javascript/flex/css/FlexCssValueValidator", "containsOnlyLetters"));
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInteger(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javascript/flex/css/FlexCssValueValidator", "isInteger"));
        }
        try {
            Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

