/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptSmartCompletionContributor
extends JSSmartCompletionContributor {
    @Nullable
    public List<?> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        JSReferenceExpression expression;
        String s;
        JSExpression calledExpr;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor", "getSmartCompletionVariants"));
        }
        PsiElement parent = location.getParent();
        List<Object> variants = new ArrayList();
        if (parent instanceof JSArgumentList && ((JSArgumentList)parent).getArguments()[0] == location && location.getQualifier() == null && (calledExpr = ((JSCallExpression)parent.getParent()).getMethodExpression()) instanceof JSReferenceExpression && ("addEventListener".equals(s = (expression = (JSReferenceExpression)calledExpr).getReferencedName()) || "removeEventListener".equals(s) || "willTrigger".equals(s) || "hasEventListener".equals(s))) {
            MyEventSubclassesProcessor subclassesProcessor = new MyEventSubclassesProcessor((PsiElement)location, variants);
            subclassesProcessor.findAcceptableVariants(expression);
            return variants;
        }
        JSType expectedClassType = JSTypeUtils.getValuableType((JSType)this.findClassType(parent));
        if (expectedClassType != null) {
            JSClass clazz = expectedClassType.resolveClass();
            if (clazz != null && !JSGenericTypeImpl.isGenericActionScriptVectorType((JSType)expectedClassType)) {
                JSCompletionContributor contributor;
                IElementType opSign;
                Query query;
                THashSet processedCandidateNames = new THashSet(50);
                if (clazz.isInterface()) {
                    query = JSClassSearch.searchInterfaceImplementations((JSClass)clazz, (boolean)true, (GlobalSearchScope)location.getResolveScope());
                } else {
                    LookupItem lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)clazz, (String)clazz.getName(), (int)102, (boolean)false, (boolean)true);
                    variants.add(lookupItem);
                    processedCandidateNames.add(clazz.getQualifiedName());
                    query = JSClassSearch.searchClassInheritors((JSClass)clazz, (boolean)true, (GlobalSearchScope)location.getResolveScope());
                }
                ActionScriptSmartCompletionContributor.addAllClassesFromQuery(variants, (Query<JSClass>)query, parent, (Set<String>)processedCandidateNames);
                if (clazz.isInterface() && parent instanceof JSBinaryExpression && ((opSign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.AS_KEYWORD || opSign == JSTokenTypes.IS_KEYWORD)) {
                    ActionScriptSmartCompletionContributor.addAllClassesFromQuery(variants, (Query<JSClass>)JSClassSearch.searchClassInheritors((JSClass)clazz, (boolean)true, (GlobalSearchScope)location.getResolveScope()), parent, (Set<String>)processedCandidateNames);
                }
                if (!(contributor = JSCompletionContributor.getInstance()).isDoingSmartCodeCompleteAction()) {
                    contributor.setAlreadyUsedClassesSet((Set)processedCandidateNames);
                }
            } else {
                JSResolveUtil.GenericSignature signature;
                String typeText = expectedClassType.getTypeText();
                if (!(expectedClassType instanceof JSAnyType)) {
                    variants.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)clazz, (String)((String)ImportUtils.importAndShortenReference((String)typeText, (PsiElement)parent, (boolean)false, (boolean)true).first + "()"), (int)101, (boolean)true, (boolean)true));
                }
                if ((signature = JSResolveUtil.extractGenericSignature((String)typeText)) != null) {
                    variants.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)JSNamedType.createType((String)"Array", (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)parent), (JSContext)JSContext.INSTANCE).resolveClass(), (String)("<" + (String)ImportUtils.importAndShortenReference((String)signature.genericType, (PsiElement)parent, (boolean)false, (boolean)true).first + ">" + "[]"), (int)101, (boolean)true, (boolean)true));
                }
            }
            return variants.isEmpty() ? Collections.emptyList() : variants;
        }
        if (location.getQualifier() == null) {
            if (JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)location)) {
                if (parent instanceof JSVariable || parent instanceof JSFunction) {
                    String qualifiedNameMatchingType;
                    JSType type = TypeFromUsageDetector.detectTypeFromUsage((PsiElement)parent, (PsiFile)parent.getContainingFile());
                    if (type == null && parent instanceof JSVariable) {
                        JSType componentType;
                        JSType expressionType;
                        JSExpression expression2;
                        PsiElement grandParent;
                        PsiElement parent2 = parent.getParent();
                        PsiElement psiElement = grandParent = parent2 instanceof JSVarStatement ? parent2.getParent() : null;
                        if (grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).isForEach() && parent2 == ((JSForInStatement)grandParent).getDeclarationStatement() && (expression2 = ((JSForInStatement)grandParent).getCollectionExpression()) != null && (expressionType = JSResolveUtil.getExpressionJSType((JSExpression)expression2)) != null && (componentType = JSTypeUtils.getComponentType((JSType)expressionType)) != null) {
                            type = componentType;
                        }
                    }
                    String string = qualifiedNameMatchingType = type != null ? JSTypeUtils.getQualifiedNameMatchingType((JSType)type, (boolean)false) : null;
                    if (qualifiedNameMatchingType != null) {
                        String qName = JSDialectSpecificHandlersFactory.forElement((PsiElement)location).getImportHandler().resolveTypeName(qualifiedNameMatchingType, (PsiElement)location).getQualifiedName();
                        variants.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)JSDialectSpecificHandlersFactory.forElement((PsiElement)location).getClassResolver().findClassByQName(qName, (PsiElement)location), (String)((String)ImportUtils.importAndShortenReference((String)qName, (PsiElement)parent, (boolean)false, (boolean)true).first), (int)101, (boolean)true, (boolean)true));
                    }
                }
            } else {
                variants = this.addVariantsForUnqualifiedReference(location);
            }
        }
        return variants.isEmpty() ? null : variants;
    }

    protected void processClasses(PsiElement parentInOriginalTree, SinkResolveProcessor<?> processor) {
        Project project = parentInOriginalTree.getProject();
        GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope((PsiElement)parentInOriginalTree);
        final LinkedHashSet qualifiedNames = new LinkedHashSet();
        JSPackageIndex.processElementsInScopeRecursive((String)"", (JSPackageIndex.PackageQualifiedElementsProcessor)new JSPackageIndex.PackageQualifiedElementsProcessor(){

            public boolean process(String qualifiedName, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (kind != JSPackageIndexInfo.Kind.FUNCTION && kind != JSPackageIndexInfo.Kind.VARIABLE) {
                    return true;
                }
                qualifiedNames.add(qualifiedName);
                return true;
            }
        }, (GlobalSearchScope)resolveScope, (Project)project);
        for (String qualifiedName : qualifiedNames) {
            PsiElement element = JSDialectSpecificHandlersFactory.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(qualifiedName, resolveScope);
            if (element == null || processor.execute(element, ResolveState.initial())) continue;
            return;
        }
    }

    private static void addAllClassesFromQuery(List<Object> variants, Query<JSClass> query, PsiElement place, Set<String> processedCandidateNames) {
        Collection all = query.findAll();
        String packageName = place != null ? JSResolveUtil.getPackageNameFromPlace((PsiElement)place) : "";
        for (JSClass result : all) {
            if (JSResolveUtil.hasExcludeClassMetadata((JSAttributeListOwner)result) || !JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)result, (String)packageName, (PsiElement)place) || !processedCandidateNames.add(result.getQualifiedName())) continue;
            variants.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)result, (String)result.getName(), (int)101, (boolean)false, (boolean)true));
        }
    }

    @Nullable
    public static JSClass findClassOfQualifier(JSReferenceExpression expression) {
        JSExpression qualifier = expression.getQualifier();
        JSClass clazzToProcess = null;
        if (qualifier != null) {
            JSClass jSClass = clazzToProcess = (qualifier = (JSExpression)PsiUtilBase.getOriginalElement((PsiElement)qualifier, qualifier.getClass())) != null ? JSResolveUtil.findClassOfQualifier((JSExpression)qualifier, (PsiFile)qualifier.getContainingFile()) : null;
        }
        if (clazzToProcess == null) {
            clazzToProcess = JSResolveUtil.getClassOfContext((PsiElement)expression);
        }
        return clazzToProcess;
    }

    public static Map<String, String> getEventsMap(JSClass clazzToProcess) {
        XmlFile file;
        if (clazzToProcess == null) {
            return Collections.emptyMap();
        }
        THashMap eventsMap = new THashMap();
        class EventsDataCollector
        extends ResolveProcessor
        implements JSResolveUtil.MetaDataProcessor {
            final /* synthetic */ Map val$eventsMap;

            public EventsDataCollector(Map map) {
                this.val$eventsMap = map;
                super(null);
                this.setToProcessHierarchy(true);
                this.setToProcessMembers(false);
                this.setTypeContext(true);
                this.setLocalResolve(true);
            }

            public boolean process(@NotNull JSAttribute jsAttribute) {
                if (jsAttribute == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor$1EventsDataCollector", "process"));
                }
                if ("Event".equals(jsAttribute.getName())) {
                    String simpleValue;
                    JSAttributeNameValuePair eventAttr = jsAttribute.getValueByName("name");
                    JSAttributeNameValuePair typeAttr = jsAttribute.getValueByName("type");
                    if (eventAttr != null && typeAttr != null && (simpleValue = eventAttr.getSimpleValue()) != null) {
                        this.val$eventsMap.put(simpleValue, typeAttr.getSimpleValue());
                    }
                }
                return true;
            }

            public boolean handleOtherElement(PsiElement el, PsiElement context, Ref<PsiElement> continuePassElement) {
                return true;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor$1EventsDataCollector", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor$1EventsDataCollector", "execute"));
                }
                if (element instanceof JSClass) {
                    JSResolveUtil.processMetaAttributesForClass((PsiElement)element, (JSResolveUtil.MetaDataProcessor)this, (boolean)true);
                }
                return true;
            }
        }
        final EventsDataCollector eventsDataCollector = new EventsDataCollector((Map)eventsMap);
        if (clazzToProcess instanceof XmlBackedJSClassImpl && (file = (XmlFile)clazzToProcess.getParent().getContainingFile()) != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file)) {
            XmlDocument xmlDocument = file.getDocument();
            XmlTag rootTag = xmlDocument == null ? null : xmlDocument.getRootTag();
            XmlTag[] tags = rootTag == null ? XmlTag.EMPTY : MxmlJSClass.findLanguageSubTags(rootTag, "Metadata");
            JSResolveUtil.JSInjectedFilesVisitor injectedFilesVisitor = new JSResolveUtil.JSInjectedFilesVisitor(){
                {
                }

                protected void process(JSFile file) {
                    for (PsiElement element : file.getChildren()) {
                        if (!(element instanceof JSAttributeList)) continue;
                        JSResolveUtil.processAttributeList((JSResolveUtil.MetaDataProcessor)eventsDataCollector, null, (JSAttributeList)((JSAttributeList)element), (boolean)true, (boolean)true);
                    }
                }
            };
            for (XmlTag tag : tags) {
                JSResolveUtil.processInjectedFileForTag((XmlTag)tag, (JSResolveUtil.JSInjectedFilesVisitor)injectedFilesVisitor);
            }
        }
        clazzToProcess.processDeclarations((PsiScopeProcessor)eventsDataCollector, ResolveState.initial(), (PsiElement)clazzToProcess, (PsiElement)clazzToProcess);
        return eventsMap;
    }

    protected int processContextClass(@NotNull JSReferenceExpression location, JSType expectedType, PsiElement parent, List<Object> variants, int qualifiedStaticVariantsStart, SinkResolveProcessor<?> processor, JSClass ourClass) {
        PsiElement element;
        JSParameterItem param;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor", "processContextClass"));
        }
        JSClass clazz = expectedType.resolveClass();
        if (clazz != null && !clazz.isEquivalentTo((PsiElement)ourClass)) {
            qualifiedStaticVariantsStart = processor.getResultSink().getResultCount();
            ActionScriptSmartCompletionContributor.processStaticsOf(clazz, processor, ourClass);
        }
        if (ourClass != null && clazz != null && JSInheritanceUtil.isParentClass((JSClass)ourClass, (JSClass)clazz, (boolean)false) && !JSResolveUtil.calculateStaticFromContext((PsiElement)location) && JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, (String)"this", (int)101, (boolean)true, (boolean)true));
        }
        if (parent instanceof JSArgumentList && (param = JSResolveUtil.findParameterForUsedArgument((JSExpression)location, (JSArgumentList)((JSArgumentList)parent))) instanceof JSParameter && (element = JSResolveUtil.findParent((PsiElement)((JSParameter)param).getParent().getParent())) instanceof JSClass && !element.isEquivalentTo((PsiElement)ourClass) && !element.isEquivalentTo((PsiElement)clazz)) {
            ActionScriptSmartCompletionContributor.processStaticsOf((JSClass)element, processor, ourClass);
        }
        return qualifiedStaticVariantsStart;
    }

    private static void processStaticsOf(JSClass parameterClass, ResolveProcessor processor, @Nullable JSClass contextClass) {
        processor.configureClassScope(contextClass);
        processor.setProcessStatics(true);
        processor.setTypeName(parameterClass.getQualifiedName());
        parameterClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)parameterClass, (PsiElement)parameterClass);
    }

    private static class MyEventSubclassesProcessor
    extends ResolveProcessor {
        private final JavaScriptIndex index;
        private final PsiElement myExpr;
        private final List<Object> myVariants;
        private final ResolveState state = new ResolveState();
        private Map<String, String> myEventsMap = new THashMap();

        public MyEventSubclassesProcessor(PsiElement expr, List<Object> variants) {
            super(null);
            this.myExpr = expr;
            this.myVariants = variants;
            this.index = JavaScriptIndex.getInstance((Project)this.myExpr.getProject());
            this.setToProcessHierarchy(true);
        }

        public boolean process(JSClass clazz) {
            clazz.processDeclarations((PsiScopeProcessor)this, this.state, (PsiElement)clazz, (PsiElement)clazz);
            return true;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            String s;
            JSVariable variable;
            JSAttributeList attributeList;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor$MyEventSubclassesProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/flex/ActionScriptSmartCompletionContributor$MyEventSubclassesProcessor", "execute"));
            }
            if (element instanceof JSVariable && (attributeList = (variable = (JSVariable)element).getAttributeList()) != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && "String".equals(variable.getTypeString()) && (s = variable.getLiteralOrReferenceInitializerText()) != null && StringUtil.startsWith((CharSequence)s, (CharSequence)"\"") && StringUtil.endsWith((CharSequence)s, (CharSequence)"\"")) {
                String key = StringUtil.stripQuotesAroundValue((String)s);
                String event = this.myEventsMap.get(key);
                if (event == null) {
                    return true;
                }
                PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
                if (!(parent instanceof JSClass) || !event.equals(((JSClass)parent).getQualifiedName())) {
                    return true;
                }
                String name = variable.getName();
                LookupItem lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)variable, (String)(((JSClass)parent).getName() + "." + name), (int)101, (boolean)false, (boolean)true);
                lookupItem.addLookupStrings(new String[]{name});
                this.myVariants.add(lookupItem);
            }
            return true;
        }

        public void findAcceptableVariants(JSReferenceExpression expression) {
            PsiElement eventClass2;
            JSClass clazzToProcess = ActionScriptSmartCompletionContributor.findClassOfQualifier(expression);
            if (clazzToProcess == null) {
                return;
            }
            this.myEventsMap = ActionScriptSmartCompletionContributor.getEventsMap(clazzToProcess);
            PsiElement eventClass1 = JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQName("flash.events.Event", this.index, ModuleUtilCore.findModuleForPsiElement((PsiElement)expression)));
            if (eventClass1 instanceof JSClass) {
                this.setToProcessMembers(true);
                this.setTypeContext(false);
                THashSet visited = new THashSet();
                for (JSClass cls : JSClassSearch.searchClassInheritors((JSClass)((JSClass)eventClass1), (boolean)true, (GlobalSearchScope)expression.getResolveScope()).findAll()) {
                    if (!visited.add(cls.getQualifiedName())) continue;
                    this.process(cls);
                }
            }
            if ((eventClass2 = JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQName("starling.events.Event", this.index, ModuleUtilCore.findModuleForPsiElement((PsiElement)expression)))) instanceof JSClass) {
                this.setToProcessMembers(true);
                this.setTypeContext(false);
                THashSet visited = new THashSet();
                for (JSClass cls : JSClassSearch.searchClassInheritors((JSClass)((JSClass)eventClass2), (boolean)true, (GlobalSearchScope)expression.getResolveScope()).findAll()) {
                    if (!visited.add(cls.getQualifiedName())) continue;
                    this.process(cls);
                }
            }
        }
    }
}

