/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.validation.ActionScriptUnusedImportsHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ActionScriptUnusedImportsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public ActionScriptUnusedImportsPassFactory(Project project, TextEditorHighlightingPassRegistrar registrar) {
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory", "createHighlightingPass"));
        }
        if (file instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file) || file instanceof JSFile && !(file instanceof PsiCompiledElement) && file.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            HighlightDisplayKey key = HighlightDisplayKey.find((String)JSUnusedLocalSymbolsInspection.SHORT_NAME);
            if (InspectionProjectProfileManager.getInstance((Project)file.getProject()).getInspectionProfile().isToolEnabled(key, (PsiElement)file)) {
                return new ActionScriptUnusedImportsHighlightingPass(file, editor);
            }
        }
        return null;
    }

    private static IntentionAction createOptimizeImportsIntention() {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = JSBundle.message((String)"javascript.fix.optimize.imports", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$1", "getText"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$1", "getFamilyName"));
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$1", "isAvailable"));
                }
                return true;
            }

            public void invoke(final @NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$1", "invoke"));
                }
                ECMAScriptImportOptimizer optimizer = new ECMAScriptImportOptimizer();
                final Runnable runnable = optimizer.processFile(file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(project, runnable, this.getFamilyName(), (Object)this);
                    }
                });
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
    }

    @NotNull
    public String getComponentName() {
        if ("ActionScript.UnusedImportReporter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory", "getComponentName"));
        }
        return "ActionScript.UnusedImportReporter";
    }

    public static class ActionScriptUnusedImportsHighlightingPass
    extends TextEditorHighlightingPass {
        private Collection<JSImportStatement> importStatements;
        private Collection<JSReferenceExpression> fqnsToReplaceWithShortName;
        private final PsiFile myFile;

        public ActionScriptUnusedImportsHighlightingPass(PsiFile file, Editor editor) {
            super(file.getProject(), editor.getDocument(), true);
            this.myFile = file;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$ActionScriptUnusedImportsHighlightingPass", "doCollectInformation"));
            }
            if (this.myFile instanceof JSExpressionCodeFragment) {
                this.importStatements = Collections.emptyList();
                this.fqnsToReplaceWithShortName = Collections.emptyList();
            } else {
                ActionScriptUnusedImportsHelper.Results results = ActionScriptUnusedImportsHelper.getUnusedImports((PsiFile)this.myFile);
                this.importStatements = results.unusedImports;
                this.fqnsToReplaceWithShortName = results.fqnsToReplaceWithShortName;
            }
        }

        public void doApplyInformationToEditor() {
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), this.getHighlights(), (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }

        private List<HighlightInfo> getHighlights() {
            AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(this.myFile));
            ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.importStatements.size() + this.fqnsToReplaceWithShortName.size());
            IntentionAction action = ActionScriptUnusedImportsPassFactory.createOptimizeImportsIntention();
            ActionScriptUnusedImportsHighlightingPass.createHighlights(this.importStatements, (AnnotationHolder)annotationHolder, action, JSBundle.message((String)"javascript.validation.unused.import", (Object[])new Object[0]), infos, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            ActionScriptUnusedImportsHighlightingPass.createHighlights(this.fqnsToReplaceWithShortName, (AnnotationHolder)annotationHolder, action, JSBundle.message((String)"javascript.validation.fqn.to.replace.with.import", (Object[])new Object[0]), infos, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return infos;
        }

        private static void createHighlights(Collection<? extends JSElement> elements, AnnotationHolder annotationHolder, IntentionAction action, String message, List<HighlightInfo> result, @NotNull ProblemHighlightType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$ActionScriptUnusedImportsHighlightingPass", "createHighlights"));
            }
            for (JSElement jSElement : elements) {
                TextRange range = InjectedLanguageManager.getInstance((Project)jSElement.getProject()).injectedToHost((PsiElement)jSElement, jSElement.getTextRange());
                if (range.isEmpty()) continue;
                Annotation annotation = annotationHolder.createWarningAnnotation(range, message);
                annotation.setHighlightType(type);
                annotation.registerFix(action);
                result.add(HighlightInfo.fromAnnotation((Annotation)annotation));
            }
        }
    }
}

