/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class LibrarySourcesSearchScope
extends GlobalSearchScope {
    private final Collection<VirtualFile> myLibrarySourceRoots;
    private final ProjectFileIndex myIndex;

    public LibrarySourcesSearchScope(Project project, Collection<VirtualFile> librarySourceRoots) {
        super(project);
        this.myLibrarySourceRoots = librarySourceRoots;
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/debug/LibrarySourcesSearchScope", "contains"));
        }
        VirtualFile libSrcRoot = this.myIndex.getSourceRootForFile(file);
        return libSrcRoot != null && this.myLibrarySourceRoots.contains(libSrcRoot);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/flex/debug/LibrarySourcesSearchScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/flex/debug/LibrarySourcesSearchScope", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/lang/javascript/flex/debug/LibrarySourcesSearchScope", "isSearchInModuleContent"));
        }
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }
}

