/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PlayTagManipulator
extends AbstractElementManipulator<PlayTag> {
    public PlayTag handleContentChange(@NotNull PlayTag playTag, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (playTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "playTag", "com/intellij/play/language/psi/PlayTagManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/play/language/psi/PlayTagManipulator", "handleContentChange"));
        }
        if (PlayTagManipulator.isNameElement(playTag, range)) {
            StringBuilder replacement = new StringBuilder(playTag.getName());
            int valueOffset = playTag.getNameElement().getTextRange().getStartOffset() - playTag.getTextOffset();
            replacement.replace(range.getStartOffset() - valueOffset, range.getEndOffset() - valueOffset, newContent);
            playTag.setName(replacement.toString());
            return playTag;
        }
        return playTag;
    }

    private static boolean isNameElement(PlayTag tag, TextRange range) {
        PsiElement nameElement = tag.getNameElement();
        if (nameElement != null) {
            TextRange tagTextRange = tag.getTextRange();
            TextRange nameElementRange = nameElement.getTextRange();
            return TextRange.create((int)(nameElementRange.getStartOffset() - tagTextRange.getStartOffset()), (int)(nameElementRange.getEndOffset() - tagTextRange.getStartOffset())).contains(range);
        }
        return false;
    }
}

