/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.usages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

public class PlayFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/usages/PlayFindUsagesHandlerFactory", "canFindUsages"));
        }
        return PlayUtils.hasSecondaryElements(element);
    }

    public FindUsagesHandler createFindUsagesHandler(final @NotNull PsiElement psiElement, boolean forHighlightUsages) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/play/usages/PlayFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        return new FindUsagesHandler(psiElement){

            @NotNull
            public PsiElement[] getSecondaryElements() {
                if (psiElement instanceof PsiClass) {
                    PsiDirectory directory = PlayPathUtils.getCorrespondingDirectory((PsiClass)psiElement);
                    if (directory != null) {
                        PsiElement[] psiElementArray = new PsiElement[]{directory};
                        if (psiElementArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/usages/PlayFindUsagesHandlerFactory$1", "getSecondaryElements"));
                        }
                        return psiElementArray;
                    }
                } else if (psiElement instanceof PsiMethod) {
                    PsiFile view = PlayPathUtils.getCorrespondingView((PsiMethod)psiElement);
                    if (view != null) {
                        PsiElement[] psiElementArray = new PsiElement[]{view};
                        if (psiElementArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/usages/PlayFindUsagesHandlerFactory$1", "getSecondaryElements"));
                        }
                        return psiElementArray;
                    }
                } else if (psiElement instanceof PlayPsiFile) {
                    PsiMethod[] psiMethodArray = PlayPathUtils.getCorrespondingControllerMethods((PsiFile)psiElement);
                    if (psiMethodArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/usages/PlayFindUsagesHandlerFactory$1", "getSecondaryElements"));
                    }
                    return psiMethodArray;
                }
                PsiElement[] psiElementArray = super.getSecondaryElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/usages/PlayFindUsagesHandlerFactory$1", "getSecondaryElements"));
                }
                return psiElementArray;
            }
        };
    }
}

