/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph;

import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.PagesFileDomFileDescription;
import com.intellij.seam.graph.beans.BasicPagesEdge;
import com.intellij.seam.graph.beans.BasicPagesNode;
import com.intellij.seam.graph.beans.ExceptionEdge;
import com.intellij.seam.graph.beans.ExceptionNode;
import com.intellij.seam.graph.beans.NavigationEdge;
import com.intellij.seam.graph.beans.PageNode;
import com.intellij.seam.graph.beans.RuleEdge;
import com.intellij.seam.graph.beans.UndefinedPageNode;
import com.intellij.seam.model.xml.PagesDomModelManager;
import com.intellij.seam.model.xml.PagesModel;
import com.intellij.seam.model.xml.pages.Navigation;
import com.intellij.seam.model.xml.pages.Page;
import com.intellij.seam.model.xml.pages.Pages;
import com.intellij.seam.model.xml.pages.PagesException;
import com.intellij.seam.model.xml.pages.PagesViewIdOwner;
import com.intellij.seam.model.xml.pages.Redirect;
import com.intellij.seam.model.xml.pages.RenderAndRedirectOwner;
import com.intellij.seam.model.xml.pages.Rule;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModuleContentRootSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagesDataModel
extends GraphDataModel<BasicPagesNode, BasicPagesEdge> {
    private final Collection<BasicPagesNode> myNodes = new HashSet();
    private final Collection<BasicPagesEdge> myEdges = new HashSet();
    protected final Map<PsiFile, NodesGroup> myGroups = new HashMap<PsiFile, NodesGroup>();
    private final Project myProject;
    private final XmlFile myFile;
    @Nullable
    private final Module myModule;
    @NonNls
    private static final String UNDEFINED_NAME = "Undefined";
    @NonNls
    private static final String DEFAULT_EXCEPTION = "Exception";

    public PagesDataModel(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
        this.myModule = ModuleUtil.findModuleForPsiElement((PsiElement)file);
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<BasicPagesNode> getNodes() {
        Collection<BasicPagesNode> collection = this.getNodes(true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<BasicPagesNode> getNodes(boolean refresh) {
        if (refresh) {
            this.refreshDataModel();
        }
        Collection<BasicPagesNode> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<BasicPagesEdge> getEdges() {
        Collection<BasicPagesEdge> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public BasicPagesNode getSourceNode(BasicPagesEdge pagesEdge) {
        BasicPagesNode basicPagesNode = pagesEdge.getSource();
        if (basicPagesNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getSourceNode"));
        }
        return basicPagesNode;
    }

    @NotNull
    public BasicPagesNode getTargetNode(BasicPagesEdge pagesEdge) {
        BasicPagesNode basicPagesNode = pagesEdge.getTarget();
        if (basicPagesNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getTargetNode"));
        }
        return basicPagesNode;
    }

    @NotNull
    public String getNodeName(BasicPagesNode pagesNode) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getNodeName"));
        }
        return "";
    }

    @NotNull
    public String getEdgeName(BasicPagesEdge pagesEdge) {
        String string = pagesEdge.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getEdgeName"));
        }
        return string;
    }

    public BasicPagesEdge createEdge(final @NotNull BasicPagesNode from, final @NotNull BasicPagesNode to) {
        ExceptionNode exceptionNode;
        PagesException exception;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/seam/graph/PagesDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/seam/graph/PagesDataModel", "createEdge"));
        }
        if (StringUtil.isEmptyOrSpaces((String)to.getName())) {
            return null;
        }
        if (from instanceof PageNode) {
            PageNode pageNode = (PageNode)from;
            final Page page = (Page)pageNode.getIdentifyingElement();
            if (page.isValid()) {
                WriteCommandAction<NavigationEdge> action = new WriteCommandAction<NavigationEdge>(this.myProject, new PsiFile[0]){

                    protected void run(@NotNull Result<NavigationEdge> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PagesDataModel$1", "run"));
                        }
                        Navigation navigation = (Navigation)page.addNavigation().createStableCopy();
                        Redirect redirect = (Redirect)navigation.getRedirect().createStableCopy();
                        redirect.getViewId().setStringValue(to.getName());
                        result.setResult((Object)new NavigationEdge(from, to, (PagesViewIdOwner)redirect, navigation));
                    }
                };
                return (BasicPagesEdge)action.execute().getResultObject();
            }
        } else if (from instanceof ExceptionNode && (exception = (PagesException)(exceptionNode = (ExceptionNode)from).getIdentifyingElement()).isValid()) {
            WriteCommandAction<ExceptionEdge> action = new WriteCommandAction<ExceptionEdge>(this.myProject, new PsiFile[0]){

                protected void run(@NotNull Result<ExceptionEdge> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PagesDataModel$2", "run"));
                    }
                    Redirect redirect = (Redirect)exception.getRedirect().createStableCopy();
                    redirect.getViewId().setStringValue(to.getName());
                    result.setResult((Object)new ExceptionEdge(from, to, redirect, exception));
                }
            };
            return (BasicPagesEdge)action.execute().getResultObject();
        }
        return null;
    }

    public void dispose() {
    }

    private void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public void updateDataModel() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Pages pages = this.getPages();
        if (pages == null) {
            return;
        }
        HashMap<String, List<PageNode>> allPageNodes = new HashMap<String, List<PageNode>>();
        this.collectPageNodes(pages.getPages(), allPageNodes);
        this.collectPageNodes(this.getPagesFromFiles(), allPageNodes);
        Map<String, List<ExceptionNode>> allExceptionNodes = this.getExceptionNodes(pages);
        HashMap<String, UndefinedPageNode> undefinedPageNodes = new HashMap<String, UndefinedPageNode>();
        Ref ref = new Ref();
        for (List list : allPageNodes.values()) {
            for (PageNode sourceNode : list) {
                Page page = (Page)sourceNode.getIdentifyingElement();
                for (Navigation navigation : page.getNavigations()) {
                    this.addTransitions(sourceNode, navigation, allPageNodes, undefinedPageNodes, PagesDataModel.getNavigationEdgeCreateFunction(sourceNode, (Ref<PagesViewIdOwner>)ref, navigation), (Ref<PagesViewIdOwner>)ref);
                    for (Rule rule : navigation.getRules()) {
                        this.addTransitions(sourceNode, rule, allPageNodes, undefinedPageNodes, PagesDataModel.getRuleEdgeCreateFunction(sourceNode, (Ref<PagesViewIdOwner>)ref, rule), (Ref<PagesViewIdOwner>)ref);
                    }
                }
            }
        }
        for (List list : allExceptionNodes.values()) {
            for (ExceptionNode exceptionNode : list) {
                PagesException pagesException = (PagesException)exceptionNode.getIdentifyingElement();
                this.addExceptionRedirectTransitions(exceptionNode, allPageNodes, pagesException, pagesException.getRedirect(), undefinedPageNodes);
            }
        }
    }

    private static Function<BasicPagesNode, BasicPagesEdge> getNavigationEdgeCreateFunction(PageNode sourceNode, Ref<PagesViewIdOwner> ref, Navigation navigation) {
        return targetNode -> new NavigationEdge((BasicPagesNode)sourceNode, (BasicPagesNode)targetNode, (PagesViewIdOwner)ref.get(), (Navigation)navigation.createStableCopy());
    }

    private static Function<BasicPagesNode, BasicPagesEdge> getRuleEdgeCreateFunction(PageNode sourceNode, Ref<PagesViewIdOwner> ref, Rule rule) {
        return targetNode -> new RuleEdge((BasicPagesNode)sourceNode, (BasicPagesNode)targetNode, (PagesViewIdOwner)ref.get(), (Rule)rule.createStableCopy());
    }

    private void addTransitions(PageNode sourceNode, RenderAndRedirectOwner go, Map<String, List<PageNode>> allPageNodes, Map<String, UndefinedPageNode> undefinedPageNodes, Function<BasicPagesNode, BasicPagesEdge> function, @NotNull Ref<PagesViewIdOwner> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/seam/graph/PagesDataModel", "addTransitions"));
        }
        ref.set((Object)go.getRedirect());
        this.addViewIdTransitions(allPageNodes, (PagesViewIdOwner)ref.get(), undefinedPageNodes, function);
        ref.set((Object)go.getRender());
        this.addViewIdTransitions(allPageNodes, (PagesViewIdOwner)ref.get(), undefinedPageNodes, function);
    }

    private void addExceptionRedirectTransitions(ExceptionNode exceptionNode, Map<String, List<PageNode>> allPageNodes, PagesException pagesException, Redirect redirect, Map<String, UndefinedPageNode> undefinedPageNodes) {
        this.addViewIdTransitions(allPageNodes, redirect, undefinedPageNodes, (Function<BasicPagesNode, BasicPagesEdge>)((Function)targetNode -> new ExceptionEdge((BasicPagesNode)exceptionNode, (BasicPagesNode)targetNode, redirect, (PagesException)pagesException.createStableCopy())));
    }

    private void addViewIdTransitions(Map<String, List<PageNode>> allPageNodes, PagesViewIdOwner viewId, Map<String, UndefinedPageNode> undefinedPageNodes, Function<BasicPagesNode, BasicPagesEdge> createEdgeFunction) {
        String toViewID = viewId.getViewId().getStringValue();
        if (toViewID != null) {
            List<? extends BasicPagesNode> targetNodes = this.getTargetNodes(toViewID, viewId, allPageNodes, undefinedPageNodes);
            for (BasicPagesNode basicPagesNode : targetNodes) {
                this.addTransition((BasicPagesEdge)createEdgeFunction.fun((Object)basicPagesNode));
            }
        }
    }

    private List<? extends BasicPagesNode> getTargetNodes(String redirectTo, PagesViewIdOwner viewId, Map<String, List<PageNode>> allPageNodes, Map<String, UndefinedPageNode> undefinedPageNodes) {
        List<PageNode> pagesNodeList = allPageNodes.get(redirectTo);
        if (pagesNodeList != null) {
            return pagesNodeList;
        }
        return Collections.singletonList(this.getOrCreateUndefinedPageNode(redirectTo, viewId, undefinedPageNodes));
    }

    @NotNull
    private UndefinedPageNode getOrCreateUndefinedPageNode(String redirectTo, PagesViewIdOwner viewId, Map<String, UndefinedPageNode> undefinedPageNodes) {
        UndefinedPageNode undefinedPageNode = undefinedPageNodes.get(redirectTo);
        if (undefinedPageNode != null) {
            UndefinedPageNode undefinedPageNode2 = undefinedPageNode;
            if (undefinedPageNode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getOrCreateUndefinedPageNode"));
            }
            return undefinedPageNode2;
        }
        UndefinedPageNode node = new UndefinedPageNode((PagesViewIdOwner)viewId.createStableCopy(), redirectTo);
        this.addNode(node);
        undefinedPageNodes.put(redirectTo, node);
        UndefinedPageNode undefinedPageNode3 = node;
        if (undefinedPageNode3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/PagesDataModel", "getOrCreateUndefinedPageNode"));
        }
        return undefinedPageNode3;
    }

    private void addNode(BasicPagesNode node) {
        this.myNodes.add(node);
    }

    private void addTransition(BasicPagesEdge edge) {
        this.myEdges.add(edge);
    }

    private void collectPageNodes(@NotNull List<Page> pages, @NotNull Map<String, List<PageNode>> pageNodes) {
        if (pages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pages", "com/intellij/seam/graph/PagesDataModel", "collectPageNodes"));
        }
        if (pageNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageNodes", "com/intellij/seam/graph/PagesDataModel", "collectPageNodes"));
        }
        for (Page page : pages) {
            if (!DomUtil.hasXml((DomElement)page)) continue;
            String name = PagesDataModel.getPageName(page);
            if (!pageNodes.containsKey(name)) {
                pageNodes.put(name, new ArrayList());
            }
            PageNode pageNode = new PageNode((Page)page.createStableCopy(), name);
            pageNodes.get(name).add(pageNode);
            this.addNode(pageNode);
        }
    }

    private static String getPageName(Page page) {
        String name = page.getViewId().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            return name;
        }
        if (DomUtil.getFileElement((DomElement)page).getFileDescription().getClass().getName().equals(PagesFileDomFileDescription.class.getName())) {
            XmlFile xmlFile = DomUtil.getFile((DomElement)page);
            String s = xmlFile.getName();
            String suffix = ".page.xml";
            if (s.contains(".page.xml")) {
                PsiDirectory psiDirectory;
                name = s.replaceAll(".page.xml", "");
                if (!StringUtil.isEmptyOrSpaces((String)name) && (psiDirectory = xmlFile.getParent()) != null) {
                    for (PsiFile file : psiDirectory.getFiles()) {
                        String webPath;
                        String fileName;
                        if (file.equals(xmlFile) || !(fileName = file.getName()).startsWith(name) || (webPath = WebUtil.getWebUtil().getWebPath(file)) == null) continue;
                        return webPath;
                    }
                }
                return s;
            }
        }
        return UNDEFINED_NAME;
    }

    private Map<String, List<ExceptionNode>> getExceptionNodes(Pages pages) {
        HashMap<String, List<ExceptionNode>> exceptionNodes = new HashMap<String, List<ExceptionNode>>();
        for (PagesException exception : pages.getExceptions()) {
            String className = exception.getClazz().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)className)) {
                className = DEFAULT_EXCEPTION;
            }
            if (!exceptionNodes.containsKey(className)) {
                exceptionNodes.put(className, new ArrayList());
            }
            ExceptionNode pageNode = new ExceptionNode((PagesException)exception.createStableCopy(), className);
            ((List)exceptionNodes.get(className)).add(pageNode);
            this.addNode(pageNode);
        }
        return exceptionNodes;
    }

    @Nullable
    public Pages getPages() {
        PagesModel model = this.getModel();
        if (model == null || model.getRoots().size() != 1) {
            return null;
        }
        return (Pages)((DomFileElement)model.getRoots().get(0)).getRootElement();
    }

    @Nullable
    public PagesModel getModel() {
        return PagesDomModelManager.getInstance(this.myProject).getPagesModel(this.myFile);
    }

    private List<Page> getPagesFromFiles() {
        ArrayList<Page> models = new ArrayList<Page>();
        if (this.myModule != null) {
            ModuleContentRootSearchScope moduleContentScope = new ModuleContentRootSearchScope(this.myModule);
            Collection files = DomService.getInstance().getDomFileCandidates(Page.class, this.myModule.getProject(), (GlobalSearchScope)moduleContentScope);
            for (VirtualFile pageflowlFile : files) {
                Page page;
                DomFileElement fileElement;
                PsiFile file = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(pageflowlFile);
                if (!(file instanceof XmlFile) || (fileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, Page.class)) == null || !fileElement.isValid() || !(page = (Page)fileElement.getRootElement()).isValid()) continue;
                models.add(page);
            }
        }
        return models;
    }
}

