/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.openshift.cloud.OSDeploymentRuntimeBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.io.IOException;

public class OSArtifactDeploymentRuntime
extends OSDeploymentRuntimeBase {
    private final File myArtifactFile;
    private final Artifact myArtifact;

    public OSArtifactDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, ArtifactDeploymentSource source, File artifactFile, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, DeploymentLogManager logManager, File repositoryRoot) throws ServerRuntimeException {
        super(serverRuntime, (DeploymentSource)source, repositoryRoot, task, logManager);
        this.myArtifactFile = artifactFile;
        this.myArtifact = source.getArtifact();
    }

    @Override
    public CloudGitApplication doDeploy() throws ServerRuntimeException {
        File artifactDestination;
        CloudGitApplication application = this.findOrCreateApplication();
        this.addOrResetGitRemote(application, this.findOrCreateRepository());
        File deployFolder = this.getRepositoryRootFile();
        File webappsFolder = new File(deployFolder, "webapps");
        File deploymentsFolder = new File(deployFolder, "deployments");
        String fileExtension = ".war";
        if (JavaeeArtifactUtil.getInstance().isJavaeeApplication(this.myArtifact.getArtifactType())) {
            fileExtension = ".ear";
        }
        if (webappsFolder.exists()) {
            artifactDestination = new File(webappsFolder, "ROOT" + fileExtension);
        } else if (deploymentsFolder.exists()) {
            artifactDestination = new File(deploymentsFolder, "ROOT" + fileExtension);
        } else {
            throw new ServerRuntimeException("Unknown Standalone Cartridge");
        }
        try {
            FileUtil.copy((File)this.myArtifactFile, (File)artifactDestination);
        }
        catch (IOException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        this.add();
        this.commit();
        this.pushApplication(application);
        return application;
    }

    @Override
    protected String[] getCleanRepositoryParameters() {
        return new String[]{"src", "pom.xml"};
    }
}

