/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.cloud.OSProvider;
import com.intellij.javaee.openshift.cloud.OSVersion;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;

public class OSCloudConfiguration
extends CloudConfigurationBase<OSCloudConfiguration>
implements OSCloudAgentConfig {
    private String myDomain;
    private String myLibraServer = OSProvider.OPENSHIFT.getApiUrl();
    private String myVersion = OSVersion.OS.getId();

    public OSVersion getVersion() {
        for (OSVersion version : OSVersion.values()) {
            if (!version.getId().equals(this.myVersion)) continue;
            return version;
        }
        return OSVersion.OS;
    }

    public void setVersion(OSVersion version) {
        this.myVersion = version.getId();
    }

    @Transient
    public boolean isOS3() {
        return this.getVersion() == OSVersion.OS3;
    }

    @Override
    @Attribute(value="domain")
    public String getDomain() {
        return this.myDomain;
    }

    public void setDomain(String domain) {
        this.myDomain = domain;
    }

    @Override
    @Attribute(value="libraServer")
    public String getLibraServer() {
        return this.myLibraServer;
    }

    public void setLibraServer(String libraServer) {
        this.myLibraServer = libraServer;
    }

    @Transient
    public OSProvider getProvider() {
        for (OSProvider provider : OSProvider.values()) {
            if (!provider.getApiUrl().equals(this.myLibraServer)) continue;
            return provider;
        }
        return null;
    }
}

