/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentDetector;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.util.RepositoryDeploymentConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudGitDeploymentChecker;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import org.jetbrains.annotations.NotNull;

public class OSDeploymentConfiguration
extends CloudDeploymentNameConfiguration<OSDeploymentConfiguration>
implements RepositoryDeploymentConfiguration {
    public static final String OS3_VERSION_WARNING = OSBundle.getText("OSDeploymentConfiguration.os3.version.warning", new Object[0]);
    public static final CloudDeploymentNameProvider DEPLOYMENT_NAME_PROVIDER = new CloudDeploymentNameProvider(){

        @NotNull
        public String getDeploymentName(@NotNull DeploymentSource deploymentSource) {
            if (deploymentSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentSource", "com/intellij/javaee/openshift/cloud/OSDeploymentConfiguration$1", "getDeploymentName"));
            }
            String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(deploymentSource).replace("_", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OSDeploymentConfiguration$1", "getDeploymentName"));
            }
            return string;
        }
    };
    private static final CloudGitDeploymentChecker<OSDeploymentConfiguration, OSCloudConfiguration, OSServerRuntimeInstance> ourCloudGitDeploymentChecker = new CloudGitDeploymentChecker((CloudGitDeploymentDetector)new OSDeploymentDetector());
    private String myRepositoryPath;
    private Integer myDebugPort;

    public String getRepositoryPath() {
        return this.myRepositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.myRepositoryPath = repositoryPath;
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    protected String getDefaultDeploymentSourceName(DeploymentSource deploymentSource) {
        return DEPLOYMENT_NAME_PROVIDER.getDeploymentName(deploymentSource);
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource) throws RuntimeConfigurationException {
        RemoteServer<?> remoteServer = server;
        if (((OSCloudConfiguration)remoteServer.getConfiguration()).isOS3()) {
            throw new RuntimeConfigurationError(OS3_VERSION_WARNING);
        }
        ourCloudGitDeploymentChecker.checkGitUrl(remoteServer, deploymentSource, (CloudDeploymentNameConfiguration)this);
    }
}

