/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.AbstractDsmTreeStructure;
import com.intellij.dsm.model.classes.NodeImpl;
import com.intellij.dsm.model.classes.NodePartitioner;
import com.intellij.dsm.settings.DsmViewSettings;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;

public abstract class TopToBottomTreeStructure<N>
extends AbstractDsmTreeStructure<N> {
    private TreeSplitter<N>[] myTreeSplitters = new TreeSplitter[0];
    private final DsmViewSettings myViewSettings;

    protected TopToBottomTreeStructure(DataGraph<N, Integer> dataGraph, DsmViewSettings settings) {
        super(dataGraph);
        this.myViewSettings = settings;
    }

    public void setTreeSplitters(TreeSplitter<N>[] treeSplitters) {
        this.fireBeforeTreeStructureChange();
        this.myTreeSplitters = treeSplitters;
        this.resetTreeStructure();
        this.fireAfterTreeStructureChange();
    }

    @Override
    protected DsmTreeStructure.TreeNode<N> createRoot() {
        return new TreeNodeImpl(null, 0, this, n -> true, null);
    }

    public boolean isGroupCycles() {
        return this.myViewSettings.isGroupCycles();
    }

    public void setGroupCycles(boolean groupCycles) {
        this.myViewSettings.setGroupCycles(groupCycles);
        this.setTreeSplitters(this.myTreeSplitters);
    }

    protected abstract String getLeafShortName(N var1);

    protected abstract String getLeafFullName(N var1);

    protected Icon getLeafIcon(N n) {
        return null;
    }

    protected static class NodeData {
        private final String myShortName;
        private final String myFullName;
        private final Icon myIcon;

        public NodeData(String shortName, String fullName, Icon icon) {
            this.myShortName = shortName;
            this.myFullName = fullName;
            this.myIcon = icon;
        }

        public String getShortName() {
            return this.myShortName;
        }

        public String getFullName() {
            return this.myFullName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    protected static interface TreeSplitter<N> {
        public List<Pair<BooleanFunction<N>, NodeData>> split(DataGraph<N, Integer> var1, BooleanFunction<N> var2, NodeData var3);
    }

    protected static class TreeNodeImpl<N>
    extends NodeImpl<N> {
        private NodeImpl<N>[] myChildren;
        private DsmTreeStructure.TreeNode<N>[] myRawChildren;
        private final TopToBottomTreeStructure<N> myTreeStructure;
        private final BooleanFunction<N> myMemberFunction;
        private final int mySplitterIndex;
        private final NodeData myNodeData;

        protected TreeNodeImpl(DsmTreeStructure.TreeNode<N> parent, int splitterIndex, TopToBottomTreeStructure<N> treeStructure, BooleanFunction<N> memberFunction, NodeData nodeData) {
            super(parent);
            this.mySplitterIndex = splitterIndex;
            this.myNodeData = nodeData;
            this.myTreeStructure = treeStructure;
            this.myMemberFunction = memberFunction;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public N getLeafData() {
            throw new UnsupportedOperationException("Method getLeafData not implemented in " + this.getClass());
        }

        @Override
        public int getLeafIndex() {
            throw new UnsupportedOperationException("Method getLeafIndex not implemented in " + this.getClass());
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getChildren() {
            if (this.myChildren != null) {
                return this.myChildren;
            }
            this.myChildren = this.computeChildren(this.mySplitterIndex, this.myMemberFunction);
            this.myChildren = this.myTreeStructure.isGroupCycles() ? NodePartitioner.partition((NodeImpl[])this.myChildren, this.myTreeStructure.getGraph(), (NodeImpl)this) : (NodeImpl[])NodePartitioner.sort((DsmTreeStructure.TreeNode[])this.myChildren, this.myTreeStructure.getGraph());
            this.myRawChildren = this.myChildren;
            this.assertNoChildrenAreLost();
            return this.myChildren;
        }

        private void assertNoChildrenAreLost() {
            DataGraph graph = this.myTreeStructure.getGraph();
            int rawCount = 0;
            for (int i = 0; i < graph.V(); ++i) {
                Object n = graph.getNode(i);
                if (!this.myMemberFunction.fun(n)) continue;
                ++rawCount;
            }
            int newCount = DsmModelUtil.countLeaves(this);
            if (newCount != rawCount) assert (false) : " wrong count";
        }

        private NodeImpl<N>[] computeChildren(int splitterIndex, BooleanFunction<N> memberFunction) {
            ArrayList<NodeImpl> result = new ArrayList<NodeImpl>();
            if (splitterIndex >= ((TopToBottomTreeStructure)this.myTreeStructure).myTreeSplitters.length) {
                DataGraph graph = this.myTreeStructure.getGraph();
                for (int i = 0; i < graph.V(); ++i) {
                    Object n = graph.getNode(i);
                    if (!memberFunction.fun(n)) continue;
                    result.add(new LeafNodeImpl<N>(this, this.myTreeStructure, i));
                }
            } else {
                List split = ((TopToBottomTreeStructure)this.myTreeStructure).myTreeSplitters[splitterIndex].split(this.myTreeStructure.getGraph(), memberFunction, this.myNodeData);
                for (Pair pair : split) {
                    BooleanFunction children = (BooleanFunction)pair.first;
                    NodeData nodeData = (NodeData)pair.second;
                    if (nodeData != null) {
                        result.add(new TreeNodeImpl<N>(this, splitterIndex, this.myTreeStructure, children, nodeData));
                        continue;
                    }
                    Object[] nodes = this.computeChildren(this.mySplitterIndex + 1, children);
                    ContainerUtil.addAll(result, (Object[])nodes);
                }
            }
            return result.toArray(new NodeImpl[result.size()]);
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getRawChildren() {
            if (this.myChildren != null) {
                return this.myChildren;
            }
            if (this.myRawChildren != null) {
                return this.myRawChildren;
            }
            ArrayList<LeafNodeImpl<N>> result = new ArrayList<LeafNodeImpl<N>>();
            DataGraph graph = this.myTreeStructure.getGraph();
            for (int i = 0; i < graph.V(); ++i) {
                Object n = graph.getNode(i);
                if (!this.myMemberFunction.fun(n)) continue;
                result.add(new LeafNodeImpl<N>(this, this.myTreeStructure, i));
            }
            this.myRawChildren = result.toArray(new DsmTreeStructure.TreeNode[result.size()]);
            return this.myRawChildren;
        }

        @Override
        public String getShortName() {
            return this.myNodeData.getShortName();
        }

        @Override
        public String getFullName() {
            return this.myNodeData.getFullName();
        }

        @Override
        public Couple<Integer>[] getCycles() {
            return new Couple[0];
        }

        @Override
        public Icon getIcon() {
            return this.myNodeData.getIcon();
        }
    }

    protected static class LeafNodeImpl<N>
    extends NodeImpl<N> {
        private final TopToBottomTreeStructure<N> myTreeStructure;
        private final int myLeafIndex;

        protected LeafNodeImpl(DsmTreeStructure.TreeNode<N> parent, TopToBottomTreeStructure<N> treeStructure, int leafIndex) {
            super(parent);
            this.myTreeStructure = treeStructure;
            this.myLeafIndex = leafIndex;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public N getLeafData() {
            return this.myTreeStructure.getGraph().getNode(this.getLeafIndex());
        }

        @Override
        public int getLeafIndex() {
            return this.myLeafIndex;
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getChildren() {
            throw new UnsupportedOperationException("Method getChildren not implemented in " + this.getClass());
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getRawChildren() {
            throw new UnsupportedOperationException("Method getRawChildren not implemented in " + this.getClass());
        }

        @Override
        public String getShortName() {
            return this.myTreeStructure.getLeafShortName(this.getLeafData());
        }

        @Override
        public String getFullName() {
            return this.myTreeStructure.getLeafFullName(this.getLeafData());
        }

        @Override
        public Couple<Integer>[] getCycles() {
            throw new UnsupportedOperationException("Method getCycles not implemented in " + this.getClass());
        }

        @Override
        public Icon getIcon() {
            return this.myTreeStructure.getLeafIcon(this.getLeafData());
        }
    }
}

