/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.ProjectScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public final class SpringMvcLibraryUtil {
    public static boolean hasSpringMvcLibrary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/web/mvc/SpringMvcLibraryUtil", "hasSpringMvcLibrary"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.web.servlet.DispatcherServlet", ProjectScope.getLibrariesScope((Project)project)) != null;
    }

    public static boolean hasSpringMvcLibrary(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/SpringMvcLibraryUtil", "hasSpringMvcLibrary"));
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") != null;
    }
}

