/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.osgi.Processor;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;

public class BndLaunchUtil {
    @NotNull
    public static JavaParameters createJavaParameters(@NotNull BndRunConfigurationBase configuration, @NotNull ProjectLauncher launcher) throws CantRunException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/osgi/bnd/run/BndLaunchUtil", "createJavaParameters"));
        }
        if (launcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcher", "org/jetbrains/osgi/bnd/run/BndLaunchUtil", "createJavaParameters"));
        }
        Project project = configuration.getProject();
        JavaParameters parameters = new JavaParameters();
        parameters.setWorkingDirectory(project.getBasePath());
        String jreHome = configuration.useAlternativeJre ? configuration.alternativeJrePath : null;
        JavaParametersUtil.configureProject((Project)project, (JavaParameters)parameters, (int)1, (String)jreHome);
        parameters.getEnv().putAll(launcher.getRunEnv());
        parameters.getVMParametersList().addAll(BndLaunchUtil.asList(launcher.getRunVM()));
        parameters.getClassPath().addAll(BndLaunchUtil.asList(launcher.getClasspath()));
        parameters.setMainClass(launcher.getMainTypeName());
        parameters.getProgramParametersList().addAll(BndLaunchUtil.asList(launcher.getRunProgramArgs()));
        JavaParameters javaParameters = parameters;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndLaunchUtil", "createJavaParameters"));
        }
        return javaParameters;
    }

    private static List<String> asList(Collection<String> c) {
        return c instanceof List ? (List)c : ContainerUtil.newArrayList(c);
    }

    @Nullable
    public static Boolean hasTestCases(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/bnd/run/BndLaunchUtil", "hasTestCases"));
        }
        File file = new File(FileUtil.toSystemDependentName((String)path));
        if (file.isFile()) {
            try {
                Processor processor = new Processor();
                processor.setProperties(file);
                if (processor.get("-runfw") != null) {
                    File projectFile;
                    if (!"bnd.bnd".equals(file.getName()) && (projectFile = new File(file.getParent(), "bnd.bnd")).isFile()) {
                        Processor project = new Processor();
                        project.setProperties(projectFile);
                        processor.setParent(project);
                    }
                    boolean hasTestCases = processor.get("Test-Cases") != null;
                    return hasTestCases ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

