/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.settings.ProjectSettings;

public class OsmorcFacet
extends Facet<OsmorcFacetConfiguration> {
    public OsmorcFacet(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/facet/OsmorcFacet", "<init>"));
        }
        this(FacetTypeRegistry.getInstance().findFacetType(OsmorcFacetType.ID), module, new OsmorcFacetConfiguration(), null, "OSGi");
    }

    public OsmorcFacet(@NotNull FacetType facetType, @NotNull Module module, @NotNull OsmorcFacetConfiguration configuration, @Nullable Facet underlyingFacet, String name) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "org/osmorc/facet/OsmorcFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/facet/OsmorcFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/osmorc/facet/OsmorcFacet", "<init>"));
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        configuration.setFacet(this);
    }

    @Nullable
    public static OsmorcFacet getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/facet/OsmorcFacet", "getInstance"));
        }
        return (OsmorcFacet)FacetManager.getInstance((Module)module).getFacetByType(OsmorcFacetType.ID);
    }

    @Nullable
    public static OsmorcFacet getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/osmorc/facet/OsmorcFacet", "getInstance"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            return OsmorcFacet.getInstance(module);
        }
        return null;
    }

    public static boolean hasOsmorcFacet(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/facet/OsmorcFacet", "hasOsmorcFacet"));
        }
        return OsmorcFacet.getInstance(module) != null;
    }

    public static boolean hasOsmorcFacet(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/osmorc/facet/OsmorcFacet", "hasOsmorcFacet"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null && OsmorcFacet.hasOsmorcFacet(module);
    }

    @NotNull
    public String getManifestLocation() {
        if (((OsmorcFacetConfiguration)this.getConfiguration()).isUseProjectDefaultManifestFileLocation()) {
            ProjectSettings projectSettings = (ProjectSettings)ModuleServiceManager.getService((Module)this.getModule(), ProjectSettings.class);
            String string = projectSettings.getDefaultManifestFileLocation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/OsmorcFacet", "getManifestLocation"));
            }
            return string;
        }
        String string = ((OsmorcFacetConfiguration)this.getConfiguration()).getManifestLocation();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/OsmorcFacet", "getManifestLocation"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getManifestFile() {
        VirtualFile[] contentRoots;
        if (((OsmorcFacetConfiguration)this.getConfiguration()).isOsmorcControlsManifest()) {
            String pathToJar = ((OsmorcFacetConfiguration)this.getConfiguration()).getJarFileLocation();
            VirtualFile jarFile = LocalFileSystem.getInstance().findFileByPath(pathToJar);
            if (jarFile == null) {
                return null;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
            if (jarRoot != null) {
                VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
                if (manifestFile == null) {
                    return null;
                }
                return manifestFile;
            }
            return null;
        }
        String path = this.getManifestLocation();
        path = path.replace('\\', '/');
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)this.getModule()).getContentRoots()) {
            VirtualFile manifestFile = contentRoot.findFileByRelativePath(path);
            if (manifestFile == null) continue;
            return manifestFile;
        }
        return null;
    }
}

