/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

class AdditionalJARContentsTableModel
extends AbstractTableModel {
    private final List<Pair<String, String>> _additionalContents = new ArrayList<Pair<String, String>>();

    AdditionalJARContentsTableModel() {
    }

    public void replaceContent(@NotNull List<Pair<String, String>> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/osmorc/facet/ui/AdditionalJARContentsTableModel", "replaceContent"));
        }
        this._additionalContents.clear();
        this._additionalContents.addAll(content);
        this.fireTableDataChanged();
    }

    @NotNull
    public List<Pair<String, String>> getAdditionalContents() {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>(this._additionalContents);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/AdditionalJARContentsTableModel", "getAdditionalContents"));
        }
        return arrayList;
    }

    public Pair<String, String> getAdditionalJARContent(int row) {
        Pair<String, String> pair = this._additionalContents.get(row);
        return Pair.create((Object)pair.getFirst(), (Object)pair.getSecond());
    }

    public void changeAdditionalJARConent(int row, @NotNull String sourcePath, String destPath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "org/osmorc/facet/ui/AdditionalJARContentsTableModel", "changeAdditionalJARConent"));
        }
        Pair changedContent = Pair.create((Object)sourcePath, (Object)destPath);
        this._additionalContents.set(row, (Pair<String, String>)changedContent);
        this.fireTableRowsUpdated(row, row);
    }

    public void deleteAdditionalJARContent(int row) {
        this._additionalContents.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public int addAdditionalJARContent(@NotNull String sourcePath, @NotNull String destPath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "org/osmorc/facet/ui/AdditionalJARContentsTableModel", "addAdditionalJARContent"));
        }
        if (destPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destPath", "org/osmorc/facet/ui/AdditionalJARContentsTableModel", "addAdditionalJARContent"));
        }
        this._additionalContents.add((Pair<String, String>)Pair.create((Object)sourcePath, (Object)destPath));
        int lastRow = this._additionalContents.size() - 1;
        this.fireTableRowsInserted(lastRow, lastRow);
        return lastRow;
    }

    @Override
    public int getRowCount() {
        return this._additionalContents.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Source File/Folder" : "Destination File/Folder (relative to JAR root)";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pair<String, String> row = this._additionalContents.get(rowIndex);
        return columnIndex == 0 ? row.getFirst() : row.getSecond();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Pair<String, String> row = this._additionalContents.get(rowIndex);
        Pair updatedRow = Pair.create((Object)(columnIndex == 0 ? (String)aValue : (String)row.getFirst()), (Object)(columnIndex == 1 ? (String)aValue : (String)row.getSecond()));
        this._additionalContents.set(rowIndex, (Pair<String, String>)updatedRow);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

