/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.ui.OsmorcFacetGeneralEditorTab;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.settings.ManifestEditor;
import org.osmorc.util.OsgiPsiUtil;

public class OsmorcFacetManifestGenerationEditorTab
extends FacetEditorTab {
    private final FacetEditorContext myEditorContext;
    private JPanel myRootPanel;
    private JTextField myBundleSymbolicName;
    private TextFieldWithBrowseButton myBundleActivator;
    private JTextField myBundleVersion;
    private JPanel myEditorPanel;
    private ManifestEditor myAdditionalPropertiesEditor;
    private boolean myModified;

    public OsmorcFacetManifestGenerationEditorTab(FacetEditorContext editorContext) {
        this.myEditorContext = editorContext;
        this.$$$setupUI$$$();
        this.myAdditionalPropertiesEditor = new ManifestEditor(this.myEditorContext.getProject(), "");
        this.myAdditionalPropertiesEditor.setPreferredSize(this.myAdditionalPropertiesEditor.getComponent().getPreferredSize());
        this.myEditorPanel.add((Component)((Object)this.myAdditionalPropertiesEditor), "Center");
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                OsmorcFacetManifestGenerationEditorTab.this.myModified = true;
            }
        });
        watcher.register((Component)this.myRootPanel);
        this.myBundleActivator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmorcFacetManifestGenerationEditorTab.this.onBundleActivatorSelect();
            }
        });
    }

    private void updateGui() {
        boolean isManuallyEdited = this.myEditorContext.getUserData(OsmorcFacetGeneralEditorTab.MANUAL_MANIFEST_EDITING_KEY) == Boolean.TRUE;
        boolean isBnd = this.myEditorContext.getUserData(OsmorcFacetGeneralEditorTab.BND_CREATION_KEY) == Boolean.TRUE;
        boolean isBundlor = this.myEditorContext.getUserData(OsmorcFacetGeneralEditorTab.BUNDLOR_CREATION_KEY) == Boolean.TRUE;
        boolean isUiEnabled = !isManuallyEdited && !isBnd && !isBundlor;
        this.myBundleSymbolicName.setEnabled(isUiEnabled);
        this.myBundleActivator.setEnabled(isUiEnabled);
        this.myBundleVersion.setEnabled(isUiEnabled);
        this.myAdditionalPropertiesEditor.getComponent().setEnabled(isUiEnabled);
    }

    private void onBundleActivatorSelect() {
        Project project = this.myEditorContext.getProject();
        PsiClass activatorClass = OsgiPsiUtil.getActivatorClass(project);
        TreeJavaClassChooserDialog.InheritanceJavaClassFilterImpl filter = new TreeJavaClassChooserDialog.InheritanceJavaClassFilterImpl(activatorClass, false, true, null);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)this.myEditorContext.getModule());
        TreeJavaClassChooserDialog dialog = new TreeJavaClassChooserDialog(OsmorcBundle.message("facet.editor.select.bundle.activator", new Object[0]), project, scope, (ClassFilter)filter, null);
        dialog.showDialog();
        PsiClass psiClass = (PsiClass)dialog.getSelected();
        if (psiClass != null) {
            this.myBundleActivator.setText(psiClass.getQualifiedName());
        }
    }

    public String getDisplayName() {
        return "Manifest Generation";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetManifestGenerationEditorTab", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this.myEditorContext.getFacet().getConfiguration();
        configuration.setBundleActivator(this.myBundleActivator.getText());
        configuration.setBundleSymbolicName(this.myBundleSymbolicName.getText());
        configuration.setBundleVersion(this.myBundleVersion.getText());
        configuration.setAdditionalProperties(this.myAdditionalPropertiesEditor.getText());
    }

    public void reset() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this.myEditorContext.getFacet().getConfiguration();
        this.myBundleActivator.setText(configuration.getBundleActivator());
        this.myBundleSymbolicName.setText(configuration.getBundleSymbolicName());
        this.myBundleVersion.setText(configuration.getBundleVersion());
        this.myAdditionalPropertiesEditor.setText(configuration.getAdditionalProperties());
        this.updateGui();
    }

    public void onTabEntering() {
        super.onTabEntering();
        this.updateGui();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myAdditionalPropertiesEditor);
    }

    public String getHelpTopic() {
        return "reference.settings.module.facet.osgi";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:271px:grow"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:d:grow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(p;4px):grow"));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Bundle Settings", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Symbolic name:");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myBundleSymbolicName = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Bundle activator:");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jLabel2, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myBundleActivator = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Bundle version:");
        jLabel3.setDisplayedMnemonic('B');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel3, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myBundleVersion = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new CellConstraints(3, 5, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Additional properties:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(11);
        jLabel4.setVerticalAlignment(0);
        jLabel4.setVerticalTextPosition(0);
        jPanel3.add((Component)jLabel4, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.myEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new CellConstraints(3, 7, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jLabel.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

