/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateStepFixBase;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberCreateAllStepsFix
extends CucumberCreateStepFixBase {
    @NotNull
    public String getName() {
        String string = CucumberBundle.message("cucumber.create.all.steps.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateAllStepsFix", "getName"));
        }
        return string;
    }

    @Override
    protected void createStepOrSteps(GherkinStep sourceStep, @Nullable Pair<PsiFile, BDDFrameworkType> fileAndFrameworkType) {
        PsiFile probableGherkinFile = sourceStep.getContainingFile();
        if (!(probableGherkinFile instanceof GherkinFile)) {
            return;
        }
        HashSet<String> createdStepDefPatterns = new HashSet<String>();
        GherkinFile gherkinFile = (GherkinFile)probableGherkinFile;
        for (GherkinFeature feature : gherkinFile.getFeatures()) {
            for (GherkinStepsHolder stepsHolder : feature.getScenarios()) {
                for (GherkinStep step : stepsHolder.getSteps()) {
                    PsiReference[] references;
                    for (PsiReference reference : references = step.getReferences()) {
                        AbstractStepDefinition definition;
                        if (!(reference instanceof CucumberStepReference) || (definition = ((CucumberStepReference)reference).resolveToDefinition()) != null) continue;
                        String pattern = Pattern.quote(step.getStepName());
                        pattern = StringUtil.trimEnd((String)StringUtil.trimStart((String)pattern, (String)"\\Q"), (String)"\\E");
                        if (createdStepDefPatterns.contains(pattern = CucumberUtil.prepareStepRegexp(pattern))) continue;
                        this.createFileOrStepDefinition(step, fileAndFrameworkType);
                        createdStepDefPatterns.add(pattern);
                    }
                }
            }
        }
    }
}

