/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.editor;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import java.util.List;

public class AspectJWordSelectionHandler
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiAspect;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ASTNode node;
        List ranges = super.select(e, editorText, cursorOffset, editor);
        if (this.canSelect(e) && (node = e.getNode()) != null) {
            ASTNode left = node.findChildByType(JavaTokenType.LBRACE);
            ASTNode right = node.findChildByType(JavaTokenType.RBRACE);
            if (left != null && right != null) {
                left = TreeUtil.skipElements((ASTNode)left.getTreeNext(), (TokenSet)ElementType.JAVA_WHITESPACE_BIT_SET);
                right = TreeUtil.skipElementsBack((ASTNode)right.getTreePrev(), (TokenSet)ElementType.JAVA_WHITESPACE_BIT_SET);
                if (left != null && right != null) {
                    TextRange range = new TextRange(left.getStartOffset(), right.getStartOffset() + right.getTextLength());
                    ranges.addAll(AspectJWordSelectionHandler.expandToWholeLine((CharSequence)editorText, (TextRange)range));
                }
            }
        }
        return ranges;
    }
}

