/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.DefaultRepositoryLocation;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceRepositoryLocation
extends DefaultRepositoryLocation {
    private final Project myProject;
    private P4Connection myConnection;
    private PerforceClient myClient;

    private PerforceRepositoryLocation(String URL2, @Nullable P4Connection connection, @Nullable Project project) {
        super(URL2);
        assert (connection != null || project != null);
        this.myConnection = connection;
        this.myProject = project;
    }

    private PerforceRepositoryLocation(String URL2, String location, @Nullable P4Connection connection, @Nullable Project project) {
        super(URL2, location);
        assert (connection != null || project != null);
        this.myConnection = connection;
        this.myProject = project;
    }

    public static PerforceRepositoryLocation create(VirtualFile file, Project project) {
        return new PerforceRepositoryLocation(file.getPath(), null, project);
    }

    public static PerforceRepositoryLocation create(FilePath p, String location, Project project) {
        return new PerforceRepositoryLocation(p.getPath(), location, null, project);
    }

    public void onAfterBatch() {
        this.myConnection = null;
        this.myClient = null;
    }

    public void onBeforeBatch() throws VcsException {
        this.myConnection = this.getConnection();
        this.myClient = this.getClient();
    }

    @NotNull
    private static P4Connection getConnection(Project project, String url) throws VcsException {
        P4Connection connection = PerforceConnectionManager.getInstance(project).getConnectionForFile(new File(url));
        if (connection == null) {
            throw new VcsException("Can not get p4 connection for root: " + url);
        }
        P4Connection p4Connection = connection;
        if (p4Connection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "getConnection"));
        }
        return p4Connection;
    }

    @NotNull
    public P4Connection getConnection() throws VcsException {
        if (this.myConnection != null) {
            P4Connection p4Connection = this.myConnection;
            if (p4Connection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "getConnection"));
            }
            return p4Connection;
        }
        P4Connection p4Connection = PerforceRepositoryLocation.getConnection(this.myProject, this.getURL());
        if (p4Connection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "getConnection"));
        }
        return p4Connection;
    }

    @NotNull
    public PerforceClient getClient() throws VcsException {
        if (this.myClient == null) {
            PerforceClient perforceClient = this.createClient(this.getConnection());
            if (perforceClient == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "getClient"));
            }
            return perforceClient;
        }
        PerforceClient perforceClient = this.myClient;
        if (perforceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "getClient"));
        }
        return perforceClient;
    }

    @NotNull
    private PerforceClient createClient(@NotNull P4Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "createClient"));
        }
        PerforceClient perforceClient = PerforceManager.getInstance(this.myProject).getClient(connection);
        if (perforceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceRepositoryLocation", "createClient"));
        }
        return perforceClient;
    }
}

