/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application.annotation;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.VFSForAnnotationListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.actions.ShowAllSubmittedFilesAction;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.annotation.AnnotationInfo;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceFileAnnotation
extends FileAnnotation {
    private final AnnotationInfo myAnnotationInfo;
    private final P4Revision[] myRevisions;
    private final VirtualFile myFile;
    private final long myRevision;
    private final VirtualFileAdapter myListener;
    private final Project myProject;
    private final List<VcsFileRevision> myPerforceRevisions;
    private final LineAnnotationAspect REVISION;
    private final LineAnnotationAspect CLIENT;
    private final LineAnnotationAspect DATE;

    public PerforceFileAnnotation(AnnotationInfo annotationInfo, VirtualFile file, P4Revision[] revisions, Project project, @NotNull P4Connection connection, long revision) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/annotation/PerforceFileAnnotation", "<init>"));
        }
        super(project);
        this.REVISION = new PerforceAnnotationAspect(LineAnnotationAspect.REVISION, false){

            public String getValue(int lineNumber) {
                P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNumber);
                if (p4Revision != null) {
                    return String.valueOf(p4Revision.getChangeNumber());
                }
                return "";
            }
        };
        this.CLIENT = new PerforceAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            public String getValue(int lineNumber) {
                P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNumber);
                if (p4Revision != null) {
                    return p4Revision.getUser();
                }
                return "";
            }
        };
        this.DATE = new PerforceAnnotationAspect(LineAnnotationAspect.DATE, true){

            public String getValue(int lineNumber) {
                P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNumber);
                if (p4Revision != null) {
                    return DateFormatUtil.formatPrettyDate((Date)p4Revision.getDate());
                }
                return "";
            }
        };
        this.myAnnotationInfo = annotationInfo;
        this.myRevisions = revisions;
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myListener = new VFSForAnnotationListener(file, (FileAnnotation)this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myListener);
        this.myPerforceRevisions = new ArrayList<VcsFileRevision>();
        for (P4Revision p4Revision : this.myRevisions) {
            this.myPerforceRevisions.add(new PerforceFileRevision(p4Revision, connection, project));
        }
        Collections.sort(this.myPerforceRevisions, (o1, o2) -> -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber()));
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myListener);
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION, this.DATE, this.CLIENT};
    }

    public String getToolTip(int lineNumber) {
        P4Revision revision = this.findRevisionForLine(lineNumber);
        return revision != null ? "Revision " + revision.getChangeNumber() + ": " + revision.getSubmitMessage() : "";
    }

    public String getAnnotatedContent() {
        return this.myAnnotationInfo.getContent();
    }

    @Nullable
    @VisibleForTesting
    public P4Revision findRevisionForLine(int lineNumber) {
        long revision = this.myAnnotationInfo.getRevision(lineNumber);
        if (revision == -1L) {
            return null;
        }
        for (P4Revision p4Revision : this.myRevisions) {
            if (!(this.myAnnotationInfo.isUseChangelistNumbers() ? p4Revision.getChangeNumber() == revision : p4Revision.getRevisionNumber() == revision)) continue;
            return p4Revision;
        }
        return null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        P4Revision p4Revision = this.findRevisionForLine(lineNumber);
        if (p4Revision != null) {
            return new PerforceVcsRevisionNumber(p4Revision);
        }
        return null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        P4Revision p4Revision = this.findRevisionForLine(lineNumber);
        return p4Revision == null ? null : p4Revision.getDate();
    }

    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    @NotNull
    public VcsRevisionNumber getCurrentRevision() {
        PerforceOnlyRevisionNumber perforceOnlyRevisionNumber = new PerforceOnlyRevisionNumber(this.myRevision);
        if (perforceOnlyRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/annotation/PerforceFileAnnotation", "getCurrentRevision"));
        }
        return perforceOnlyRevisionNumber;
    }

    public List<VcsFileRevision> getRevisions() {
        return this.myPerforceRevisions;
    }

    public boolean revisionsNotEmpty() {
        return !this.myPerforceRevisions.isEmpty();
    }

    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    public int getLineCount() {
        return this.myAnnotationInfo.getLineCount();
    }

    public VcsKey getVcsKey() {
        return PerforceVcs.getKey();
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        return PerforceVcs.getInstance(this.myProject).revisionsSame(this.getCurrentRevision(), number);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    private abstract class PerforceAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public PerforceAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected void showAffectedPaths(int lineNum) {
            P4Revision p4Revision = PerforceFileAnnotation.this.findRevisionForLine(lineNum);
            P4Connection connection = PerforceConnectionManager.getInstance(PerforceFileAnnotation.this.myProject).getConnectionForFile(PerforceFileAnnotation.this.myFile);
            if (p4Revision != null && connection != null) {
                long changeNumber = p4Revision.getChangeNumber();
                ShowAllSubmittedFilesAction.showAllSubmittedFiles(PerforceFileAnnotation.this.myProject, changeNumber, p4Revision.getSubmitMessage(), p4Revision.getDate(), p4Revision.getUser(), connection);
            }
        }
    }
}

