/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AbstractKotlinType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KotlinTypeImpl
extends AbstractKotlinType {
    private final Annotations annotations;
    private final TypeConstructor constructor;
    private final boolean nullable;
    private final List<TypeProjection> arguments;
    private final TypeSubstitution substitution;
    private final MemberScope memberScope;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public TypeSubstitution getSubstitution() {
        if (this.substitution == null) {
            return TypeConstructorSubstitution.Companion.create(this.getConstructor(), this.getArguments());
        }
        return this.substitution;
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.nullable;
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return this.memberScope;
    }

    @Override
    public boolean isError() {
        return false;
    }

    private KotlinTypeImpl(Annotations annotations2, TypeConstructor constructor, boolean nullable2, List<? extends TypeProjection> arguments2, TypeSubstitution substitution, MemberScope memberScope2) {
        this.annotations = annotations2;
        this.constructor = constructor;
        this.nullable = nullable2;
        this.arguments = arguments2;
        this.substitution = substitution;
        this.memberScope = memberScope2;
        if (this.memberScope instanceof ErrorUtils.ErrorScope) {
            throw (Throwable)new IllegalStateException("JetTypeImpl should not be created for error type: " + this.memberScope + "\n" + this.constructor);
        }
    }

    public /* synthetic */ KotlinTypeImpl(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, boolean nullable2, @NotNull List arguments2, @Nullable TypeSubstitution substitution, @NotNull MemberScope memberScope2, DefaultConstructorMarker $constructor_marker) {
        this(annotations2, constructor, nullable2, arguments2, substitution, memberScope2);
    }

    @JvmStatic
    @NotNull
    public static final KotlinTypeImpl create(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @NotNull MemberScope memberScope2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
        return Companion.create(annotations2, constructor, nullable2, arguments2, memberScope2);
    }

    @JvmStatic
    @NotNull
    public static final KotlinTypeImpl create(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @NotNull TypeSubstitution substitution, @NotNull MemberScope memberScope2, @NotNull TypeCapabilities capabilities) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(substitution, "substitution");
        Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
        Intrinsics.checkParameterIsNotNull(capabilities, "capabilities");
        return Companion.create(annotations2, constructor, nullable2, arguments2, substitution, memberScope2, capabilities);
    }

    @JvmStatic
    @NotNull
    public static final KotlinTypeImpl create(@NotNull Annotations annotations2, @NotNull ClassDescriptor descriptor2, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        return Companion.create(annotations2, descriptor2, nullable2, arguments2);
    }

    private static final class WithCapabilities
    extends KotlinTypeImpl {
        private final TypeCapabilities typeCapabilities;

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            return this.typeCapabilities;
        }

        public WithCapabilities(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @Nullable TypeSubstitution substitution, @NotNull MemberScope memberScope2, @NotNull TypeCapabilities typeCapabilities2) {
            Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
            Intrinsics.checkParameterIsNotNull(typeCapabilities2, "typeCapabilities");
            super(annotations2, constructor, nullable2, arguments2, substitution, memberScope2, null);
            this.typeCapabilities = typeCapabilities2;
        }
    }

    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KotlinTypeImpl create(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @NotNull MemberScope memberScope2) {
            Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
            return new KotlinTypeImpl(annotations2, constructor, nullable2, arguments2, null, memberScope2, null);
        }

        @JvmStatic
        @NotNull
        public final KotlinTypeImpl create(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @NotNull TypeSubstitution substitution, @NotNull MemberScope memberScope2, @NotNull TypeCapabilities capabilities) {
            Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(substitution, "substitution");
            Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
            Intrinsics.checkParameterIsNotNull(capabilities, "capabilities");
            if (capabilities != TypeCapabilities.NONE.INSTANCE) {
                return new WithCapabilities(annotations2, constructor, nullable2, arguments2, substitution, memberScope2, capabilities);
            }
            return new KotlinTypeImpl(annotations2, constructor, nullable2, arguments2, substitution, memberScope2, null);
        }

        @JvmStatic
        @NotNull
        public final KotlinTypeImpl create(@NotNull Annotations annotations2, @NotNull ClassDescriptor descriptor2, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2) {
            Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "descriptor.typeConstructor");
            TypeSubstitution typeSubstitution = null;
            MemberScope memberScope2 = descriptor2.getMemberScope(arguments2);
            Intrinsics.checkExpressionValueIsNotNull(memberScope2, "descriptor.getMemberScope(arguments)");
            return new KotlinTypeImpl(annotations2, typeConstructor2, nullable2, arguments2, typeSubstitution, memberScope2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

