/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTestHelper;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.exceptions.DBProtectionException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.sql.SqlScriptBuilder;
import org.jetbrains.dekaf.util.Collects;

public abstract class BaseTestHelper<F extends DBFacade>
implements DBTestHelper {
    @NotNull
    protected final F db;
    @NotNull
    protected final Scriptum scriptum;
    @NotNull
    protected final Set<String> schemasNotToZap = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    protected BaseTestHelper(@NotNull F db, @NotNull Scriptum scriptum) {
        this.db = db;
        this.scriptum = scriptum;
        this.schemasNotToZap.add("information_schema");
    }

    @Override
    @NotNull
    public String fromSingleRowTable() {
        return "";
    }

    @Override
    public void performCommand(@NotNull Scriptum scriptum, @NotNull String commandName) {
        SqlCommand command = scriptum.command(commandName);
        this.performCommand(command);
    }

    @Override
    public void performCommand(@NotNull String commandText) {
        SqlCommand command = new SqlCommand(commandText);
        this.performCommand(command);
    }

    @Override
    public void performCommand(final @NotNull SqlCommand command) {
        this.db.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                session.command(command).run();
            }
        });
    }

    @Override
    public void performCommand(@NotNull DBTransaction transaction, @NotNull Scriptum scriptum, @NotNull String commandName) {
        SqlCommand command = scriptum.command(commandName);
        this.performCommand(transaction, command);
    }

    @Override
    public void performCommand(@NotNull DBTransaction transaction, @NotNull String commandText) {
        SqlCommand command = new SqlCommand(commandText);
        this.performCommand(transaction, command);
    }

    @Override
    public void performCommand(@NotNull DBTransaction transaction, @NotNull SqlCommand command) {
        transaction.command(command).run();
    }

    @Override
    public void performScript(@NotNull Scriptum scriptum, @NotNull String scriptName) {
        SqlScript script = scriptum.script(scriptName);
        this.performScript(script);
    }

    @Override
    public void performScript(final @NotNull SqlScript script) {
        this.db.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                session.script(script).run();
            }
        });
    }

    @Override
    public void performScript(String ... commands) {
        if (commands == null || commands.length == 0) {
            return;
        }
        SqlScriptBuilder b = new SqlScriptBuilder();
        for (String c : commands) {
            b.add(c);
        }
        this.performScript(b.build());
    }

    @Override
    public void performCommandOrMetaQueryCommands(@NotNull Scriptum scriptum, @NotNull String operationName) {
        if (scriptum.findText(operationName + "Command") != null) {
            this.performCommand(scriptum, operationName + "Command");
        } else if (scriptum.findText(operationName + "MetaQuery") != null) {
            this.performMetaQueryCommands(scriptum, operationName + "MetaQuery", new Object[0]);
        } else {
            throw new IllegalArgumentException(String.format("The scriptum has no operation %sCommand or %sMetaQuery", operationName, operationName));
        }
    }

    @Override
    public void performMetaQueryCommands(@NotNull Scriptum scriptum, @NotNull String metaQueryName, final Object ... params) {
        final SqlQuery<List<String>> metaQuery = scriptum.query(metaQueryName, Layouts.listOf(Layouts.oneOf(String.class)));
        this.db.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                List commands = (List)session.query(metaQuery).withParams(params).run();
                SqlScriptBuilder sb = new SqlScriptBuilder();
                for (String command : commands) {
                    if (command == null || command.length() <= 0) continue;
                    sb.add(command);
                }
                SqlScript script = sb.build();
                session.script(script).run();
            }
        });
    }

    @Override
    public int countTableRows(final @NotNull String tableName) {
        return this.db.inSession(new InSession<Integer>(){

            @Override
            public Integer run(@NotNull DBSession session) {
                return BaseTestHelper.this.countTableRows(session, tableName);
            }
        });
    }

    @Override
    public int countTableRows(@NotNull DBTransaction transaction, @NotNull String tableName) {
        String queryText = "select count(*) from " + tableName;
        try {
            return transaction.query(queryText, Layouts.singleOf(Integer.class)).run();
        }
        catch (NoTableOrViewException ntv) {
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public void ensureNoTableOrView(String ... names) {
        String[][] namePacks;
        for (Object[] objectArray : namePacks = Collects.splitArrayPer(names, 4)) {
            Object[] params;
            if (objectArray.length == 4) {
                params = objectArray;
            } else {
                params = new String[4];
                System.arraycopy(objectArray, 0, params, 0, objectArray.length);
                Arrays.fill(params, objectArray.length, 4, "");
            }
            this.ensureNoTableOrView4(params);
        }
    }

    protected void ensureNoTableOrView4(Object[] params) {
        this.performMetaQueryCommands(this.scriptum, "EnsureNoTableOrViewMetaQuery", params);
    }

    @Override
    public void zapSchema() {
        ConnectionInfo connectionInfo = this.db.getConnectionInfo();
        String schemaName = connectionInfo.schemaName;
        if (schemaName != null && this.schemasNotToZap.contains(schemaName)) {
            throw new DBProtectionException(String.format("The schema %s must not be zapped", schemaName), "zapSchema");
        }
        this.zapSchemaInternally(connectionInfo);
    }

    protected void zapSchemaInternally(ConnectionInfo connectionInfo) {
        this.performCommandOrMetaQueryCommands(this.scriptum, "ZapSchema");
    }
}

