/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseTestHelper;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.sql.Scriptum;

public class PostgresTestHelper
extends BaseTestHelper<DBFacade> {
    public PostgresTestHelper(@NotNull DBFacade db) {
        super(db, Scriptum.of(PostgresTestHelper.class));
        this.schemasNotToZap.add("pg_catalog");
    }

    @Override
    public void prepareX1() {
        this.performCommand("create or replace view X1 as select 1");
    }

    @Override
    public void prepareX1000() {
        this.performCommand(this.scriptum, "X1000");
    }

    @Override
    public void prepareX1000000() {
        this.performCommand(this.scriptum, "X1000000");
    }

    @Override
    protected void zapSchemaInternally(ConnectionInfo connectionInfo) {
        ConnectionInfo info = this.db.getConnectionInfo();
        if (info.serverVersion.isOrGreater(9, 1)) {
            this.performMetaQueryCommands(this.scriptum, "ZapExtensionsMetaQuery", new Object[0]);
        }
        this.performMetaQueryCommands(this.scriptum, "ZapSchemaMetaQuery", new Object[0]);
    }
}

