/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseTestHelper;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.exceptions.UnknownDBException;
import org.jetbrains.dekaf.sql.Scriptum;

public class UnknownDBTestHelper
extends BaseTestHelper<DBFacade> {
    private boolean initialized;
    private boolean isOracle;
    private boolean isDB2;
    private boolean isHsql;
    private boolean isDerby;
    private String fromSingleRowTable = "";

    public UnknownDBTestHelper(@NotNull DBFacade db) {
        super(db, Scriptum.of(UnknownDBTestHelper.class));
        if (db.isConnected()) {
            this.initVariables();
        }
    }

    private void initVariablesIfNeeded() {
        if (!this.initialized) {
            assert (this.db.isConnected()) : "Expected that is connected to DB";
            this.initVariables();
        }
    }

    private void initVariables() {
        ConnectionInfo info = this.db.getConnectionInfo();
        this.isOracle = info.rdbmsName.startsWith("Oracle");
        this.isDB2 = info.rdbmsName.startsWith("DB2");
        this.isHsql = info.rdbmsName.startsWith("HSQL");
        this.isDerby = info.rdbmsName.contains("Derby");
        this.fromSingleRowTable = this.isOracle ? " from dual" : (this.isDB2 || this.isDerby ? " from sysibm.sysdummy1" : (this.isHsql ? " from information_schema.schemata limit 1" : ""));
        this.initialized = true;
    }

    @Override
    public void prepareX1() {
        this.performCommand("create or replace view X1 as select 1 as X" + this.fromSingleRowTable);
    }

    @Override
    public void prepareX1000() {
        this.performCommand(this.scriptum, "X10");
        this.performCommand(this.scriptum, "X1000");
    }

    @Override
    public void prepareX1000000() {
        this.prepareX1000();
        this.performCommand(this.scriptum, "X1000000");
    }

    @Override
    @NotNull
    public String fromSingleRowTable() {
        this.initVariablesIfNeeded();
        return this.fromSingleRowTable;
    }

    @Override
    public void ensureNoTableOrView(final String ... names) {
        final String[] tableTypes = new String[]{"TABLE", "VIEW"};
        final ConnectionInfo connectionInfo = this.db.getConnectionInfo();
        if (connectionInfo.databaseName == null) {
            throw new IllegalStateException("Cannot clean schema when the database name is unknown");
        }
        if (connectionInfo.schemaName == null) {
            throw new IllegalStateException("Cannot clean schema when the schema name is unknown");
        }
        this.db.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                for (String name : names) {
                    UnknownDBTestHelper.this.zapTables(session, connectionInfo, name, tableTypes);
                }
            }
        });
    }

    @Override
    public void zapSchema() {
        final ConnectionInfo connectionInfo = this.db.getConnectionInfo();
        if (connectionInfo.databaseName == null) {
            throw new IllegalStateException("Cannot clean schema when the database name is unknown");
        }
        if (connectionInfo.schemaName == null) {
            throw new IllegalStateException("Cannot clean schema when the schema name is unknown");
        }
        this.db.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                UnknownDBTestHelper.this.zapTables(session, connectionInfo, "%", null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zapTables(DBSession session, ConnectionInfo connectionInfo, String tableNameMask, String[] tableTypes) {
        DatabaseMetaData md = session.getSpecificService(DatabaseMetaData.class, "jdbc-metadata");
        if (md == null) {
            throw new RuntimeException("Unable to obtain metadata from unknown database");
        }
        ArrayList<String> commands = new ArrayList<String>();
        try {
            ResultSet tables = md.getTables(connectionInfo.databaseName, connectionInfo.schemaName, tableNameMask, tableTypes);
            try {
                while (tables.next()) {
                    String tableName = tables.getString(3);
                    String tableType = tables.getString(4);
                    if (tableName == null || tableName.isEmpty() || tableType == null || tableType.isEmpty() || (tableType = tableType.toLowerCase()).contains("system")) continue;
                    String command = "drop " + tableType + ' ' + '\"' + tableName + '\"';
                    commands.add(command);
                }
            }
            finally {
                tables.close();
            }
        }
        catch (SQLException e) {
            throw new UnknownDBException("Unable to list tables of unknown schema: " + e.getMessage(), (Exception)e, null);
        }
        ArrayList<String> errors = new ArrayList<String>(0);
        Connection connection = session.getSpecificService(Connection.class, "jdbc-connection");
        assert (connection != null);
        try {
            Statement stmt = connection.createStatement();
            try {
                for (String command : commands) {
                    try {
                        stmt.execute(command);
                    }
                    catch (SQLException e) {
                        String errMessage = "Failed to " + command + ": " + e.getMessage();
                        errors.add(errMessage);
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new UnknownDBException("Unable to list tables of unknown schema: " + e.getMessage(), (Exception)e, null);
        }
        if (!errors.isEmpty()) {
            StringBuffer b = new StringBuffer(errors.size() * 100);
            b.append(errors.size()).append(" errors occurred when attempted to clean the schema:\n");
            for (String error : errors) {
                b.append('\t').append(error).append('\n');
            }
            throw new RuntimeException(b.toString());
        }
    }
}

