/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.MysqlIntermediateSession;

public class MysqlIntermediateFacade
extends JdbcIntermediateFacade {
    private byte myFetchStrategy = 0;
    private static final String CONNECTION_INFO_QUERY = "select database(), schema(), left(user(),instr(concat(user(),'@'),'@')-1)";

    public MysqlIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public MysqlIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Mysql.RDBMS;
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.getConnectionInfoSmartly(CONNECTION_INFO_QUERY, SIMPLE_VERSION_PATTERN, 1, SIMPLE_VERSION_PATTERN, 1);
    }

    @Override
    @NotNull
    protected MysqlIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new MysqlIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    public byte getFetchStrategy() {
        return this.myFetchStrategy;
    }

    public void setFetchStrategy(byte fetchStrategy) {
        this.myFetchStrategy = fetchStrategy;
    }
}

