/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.exceptions.OracleTimezoneRegionNotFoundException;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.OracleIntermediateSession;
import org.jetbrains.dekaf.jdbc.pooling.SimpleDataSource;

public class OracleIntermediateFacade
extends JdbcIntermediateFacade {
    private Boolean myCompatibility1882;
    private static final String CONNECTION_INFO_QUERY = "select sys_context('userenv', 'db_name') as database_name,      \n       sys_context('userenv', 'current_schema') as schema_name, \n       user as user_name                                        \nfrom dual                                                       \n";

    public OracleIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public OracleIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Oracle.RDBMS;
    }

    @Override
    public synchronized void connect() {
        while (true) {
            try {
                super.connect();
            }
            catch (OracleTimezoneRegionNotFoundException otr) {
                if (this.myCompatibility1882 != null) break;
                DataSource originalDataSource = this.myPool.getOriginalDataSource();
                if (originalDataSource instanceof SimpleDataSource) {
                    SimpleDataSource sds = (SimpleDataSource)originalDataSource;
                    sds.setConnectionProperty("oracle.jdbc.timezoneAsRegion", "false");
                    this.myCompatibility1882 = Boolean.TRUE;
                    continue;
                }
                this.myCompatibility1882 = Boolean.FALSE;
            }
            break;
        }
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new OracleIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.getConnectionInfoSmartly(CONNECTION_INFO_QUERY, SIMPLE_VERSION_PATTERN, 1, SIMPLE_VERSION_PATTERN, 1);
    }
}

