/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCommandLineUtil {
    private static final Logger LOG = Logger.getInstance(NodeCommandLineUtil.class);

    protected NodeCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, long timeoutMillis, @Nullable ProcessListener processListener) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        ProcessOutput processOutput = NodeCommandLineUtil.execute(commandLine, timeoutMillis);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, long timeoutMillis) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        commandLine.setCharset(Charsets.UTF_8);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, false);
        processHandler.setShouldDestroyProcessRecursively(true);
        processHandler.setShouldKillProcessSoftly(true);
        ProcessOutputCatcher outputCatcher = new ProcessOutputCatcher((BaseOSProcessHandler)processHandler);
        outputCatcher.startNotify();
        if (!outputCatcher.run(timeoutMillis)) {
            outputCatcher.terminateAndWait();
            outputCatcher.getOutput().setTimeout();
        }
        ProcessOutput processOutput = outputCatcher.getOutput();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "execute"));
        }
        return processOutput;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir, @NotNull File nodeFile, @NotNull File npmFile, @NotNull List<String> arguments) {
        File npmJsMainFile;
        if (nodeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeFile", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        if (npmFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmFile", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(Charsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        if ((npmJsMainFile = NodeCommandLineUtil.findNpmJsMainFile(nodeFile, npmFile)) != null) {
            commandLine.setExePath(nodeFile.getAbsolutePath());
            commandLine.addParameter(npmJsMainFile.getAbsolutePath());
        } else {
            commandLine.setExePath(npmFile.getAbsolutePath());
        }
        commandLine.addParameters(arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir, @NotNull NodeJsLocalInterpreter interpreter, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(Charsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(interpreter.getValidNpmCliJsFilePath());
        commandLine.addParameters(arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "createNpmCommandLine"));
        }
        return generalCommandLine;
    }

    @Nullable
    private static File findNpmJsMainFile(@NotNull File nodeInterpreter, @NotNull File npmExecutable) {
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "findNpmJsMainFile"));
        }
        if (npmExecutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmExecutable", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "findNpmJsMainFile"));
        }
        if ("npm-cli.js".equals(npmExecutable.getName()) && npmExecutable.isFile()) {
            return npmExecutable;
        }
        File mainJsFile = null;
        if (SystemInfo.isWindows) {
            mainJsFile = NodeCommandLineUtil.findNpmCli(nodeInterpreter, npmExecutable);
        } else {
            boolean executableWithNode = false;
            try {
                executableWithNode = NodeCommandLineUtil.isExecutableWithNode(npmExecutable);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (executableWithNode && !npmExecutable.getName().endsWith(".sh")) {
                mainJsFile = npmExecutable;
            }
        }
        if (mainJsFile == null) {
            LOG.warn("Cannot locate npm js main file for " + nodeInterpreter.getAbsolutePath() + " and " + npmExecutable.getAbsolutePath());
        }
        return mainJsFile;
    }

    @Nullable
    private static File findNpmCli(@NotNull File nodeFile, @NotNull File npmFile) {
        if (nodeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeFile", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "findNpmCli"));
        }
        if (npmFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmFile", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "findNpmCli"));
        }
        File npmCliFile = null;
        if (npmFile.getName().equals("npm.cmd")) {
            npmCliFile = NodeCommandLineUtil.findNpmCli(npmFile.getParentFile());
        }
        if (npmCliFile == null) {
            npmCliFile = NodeCommandLineUtil.findNpmCli(nodeFile.getParentFile());
        }
        return npmCliFile;
    }

    @Nullable
    private static File findNpmCli(@NotNull File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "findNpmCli"));
        }
        File file = new File(baseDir, "node_modules\\npm\\bin\\npm-cli.js");
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    private static boolean isExecutableWithNode(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "isExecutableWithNode"));
        }
        CharSource charSource = Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
        try (Closer closer = Closer.create();){
            String second;
            BufferedReader reader = (BufferedReader)closer.register((Closeable)charSource.openBufferedStream());
            String first = reader.readLine();
            if (first == null) {
                boolean bl = false;
                return bl;
            }
            if (first.startsWith("#!/") && first.endsWith(" node")) {
                boolean bl = true;
                return bl;
            }
            if ("#!/bin/sh".equals(first) && ("// 2>/dev/null; exec \"`dirname \"$0\"`/node\" \"$0\" \"$@\"".equals(second = reader.readLine()) || "// 2>/dev/null; exec \"`dirname \"$0\"`/iojs\" \"$0\" \"$@\"".equals(second))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void configureUsefulEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "configureUsefulEnvironment"));
        }
        NodeCommandLineUtil.configureDebugPackageSupport(commandLine);
        NodeCommandLineUtil.enableAnsiColorSupport(commandLine);
    }

    public static void configureDebugPackageSupport(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "configureDebugPackageSupport"));
        }
        NodeCommandLineUtil.setEnvIfMissing(commandLine, "DEBUG_COLORS", "true");
        NodeCommandLineUtil.setEnvIfMissing(commandLine, "DEBUG_FD", "1");
    }

    public static void enableAnsiColorSupport(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "enableAnsiColorSupport"));
        }
        NodeCommandLineUtil.setEnvIfMissing(commandLine, "FORCE_COLOR", "true");
        NodeCommandLineUtil.setEnvIfMissing(commandLine, "MOCHA_COLORS", "1");
        NodeCommandLineUtil.setEnvIfMissing(commandLine, "ELECTRON_NO_ATTACH_CONSOLE", "true");
    }

    private static void setEnvIfMissing(@NotNull GeneralCommandLine commandLine, @NotNull String name, @NotNull String value) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "setEnvIfMissing"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "setEnvIfMissing"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "setEnvIfMissing"));
        }
        if (!commandLine.getEnvironment().containsKey(name)) {
            commandLine.getEnvironment().put(name, value);
        }
    }

    public static String formatErrorMessage(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "formatErrorMessage"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/javascript/nodejs/NodeCommandLineUtil", "formatErrorMessage"));
        }
        StringBuilder buf = new StringBuilder("\n");
        buf.append(commandLine.getCommandLineString());
        buf.append("\n\n");
        buf.append("Exit code: ").append(output.getExitCode());
        if (output.getStderr().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard error:\n").append(output.getStderr());
        }
        if (output.getStdout().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard output:\n").append(output.getStdout());
        }
        return buf.toString();
    }
}

