/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class NodeModuleSearchUtil {
    private static final String NODE_MODULES = "node_modules";
    private static final Map<VirtualFile, Pair<String, Long>> MAIN_KEY_VALUE_FROM_PACKAGE_JSON_CACHE = Collections.synchronizedMap(new LinkedHashMap<VirtualFile, Pair<String, Long>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<VirtualFile, Pair<String, Long>> eldest) {
            return this.size() > 1000;
        }
    });
    private static final Map<VirtualFile, Pair<String, Long>> REDIRECT_PATHS_CACHE = Collections.synchronizedMap(new LinkedHashMap<VirtualFile, Pair<String, Long>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<VirtualFile, Pair<String, Long>> eldest) {
            return this.size() > 1000;
        }
    });
    public static final String[] FILE_EXTENSIONS_IN_ORDER = new String[]{".coffee", ".d.ts", ".ts", ".js", ".jsx", ".json", ".node"};
    @NonNls
    private static final String PACKAGE_JSON = "package.json";

    private NodeModuleSearchUtil() {
    }

    public static void findModulesWithName(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings, boolean includeGloballyInstalled) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithName"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithName"));
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules, requester, moduleName);
        }
        if (nodeSettings != null) {
            VirtualFile globalNodeModulesDir;
            NodeModuleSearchUtil.findModulesWithNameInGlobalFolders(modules, moduleName, nodeSettings.getGlobalFolders());
            if (includeGloballyInstalled && (globalNodeModulesDir = nodeSettings.getGlobalNodeModulesVirtualDir()) != null) {
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
            }
        }
    }

    public static void findModulesByNameInContentRoots(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull Project project, boolean includeNodeModulesOfSecondLevel, @Nullable NodeSettings nodeSettings, boolean includeGloballyInstalled) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInContentRoots"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInContentRoots"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInContentRoots"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesByNameInContentRoots$0"));
            }
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesByNameInContentRoots$0"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesByNameInContentRoots$0"));
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile nodeModulesDir = contentRoot.findChild(NODE_MODULES);
                    if (!NodeModuleSearchUtil.isDirectory(nodeModulesDir)) continue;
                    if (includeNodeModulesOfSecondLevel) {
                        NodeModuleSearchUtil.findModulesByNameInNodeModulesOfFirstAndSecondsLevels(modules, nodeModulesDir, moduleName);
                        continue;
                    }
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
                }
            }
            if (nodeSettings != null) {
                VirtualFile globalNodeModulesDir;
                NodeModuleSearchUtil.findModulesWithNameInGlobalFolders(modules, moduleName, nodeSettings.getGlobalFolders());
                if (includeGloballyInstalled && (globalNodeModulesDir = nodeSettings.getGlobalNodeModulesVirtualDir()) != null) {
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName);
                }
            }
        });
    }

    private static void findModulesWithNameFromNodeModulesDir(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile requester, @NotNull String moduleName) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameFromNodeModulesDir"));
        }
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameFromNodeModulesDir"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameFromNodeModulesDir"));
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesWithNameFromNodeModulesDir$1"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$findModulesWithNameFromNodeModulesDir$1"));
            }
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
            return true;
        }));
    }

    private static void findModulesWithNameInGlobalFolders(@NotNull List<CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull List<VirtualFile> globalFolders) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameInGlobalFolders"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameInGlobalFolders"));
        }
        if (globalFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesWithNameInGlobalFolders"));
        }
        for (VirtualFile dir : globalFolders) {
            if (!dir.isValid() || !dir.isDirectory()) continue;
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, dir, ModuleType.GLOBAL_FOLDER, moduleName);
        }
    }

    private static void findModulesByNameInNodeModulesOfFirstAndSecondsLevels(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile firstLevelNodeModulesDir, @NotNull String moduleName) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInNodeModulesOfFirstAndSecondsLevels"));
        }
        if (firstLevelNodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstLevelNodeModulesDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInNodeModulesOfFirstAndSecondsLevels"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModulesByNameInNodeModulesOfFirstAndSecondsLevels"));
        }
        for (VirtualFile moduleDir : firstLevelNodeModulesDir.getChildren()) {
            VirtualFile secondLevelModuleDir;
            VirtualFile secondLevelNodeModulesDir;
            if (!moduleDir.isDirectory()) continue;
            String name = moduleDir.getName();
            if (moduleName.equals(name) && NodeModuleSearchUtil.canLoadDirectory(moduleDir)) {
                modules.add(new CompletionModuleInfo(name, moduleDir, ModuleType.NODE_MODULES_DIR));
            }
            if (!NodeModuleSearchUtil.isDirectory(secondLevelNodeModulesDir = moduleDir.findChild(NODE_MODULES)) || !NodeModuleSearchUtil.isDirectory(secondLevelModuleDir = secondLevelNodeModulesDir.findChild(moduleName)) || !NodeModuleSearchUtil.canLoadDirectory(secondLevelModuleDir)) continue;
            modules.add(new CompletionModuleInfo(name, secondLevelModuleDir, ModuleType.NODE_MODULES_DIR));
        }
    }

    private static boolean findModuleWithNameInDirectory(@NotNull List<CompletionModuleInfo> modules, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName) {
        boolean ok;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findModuleWithNameInDirectory"));
        }
        VirtualFile child = dir.findChild(moduleName);
        if (child == null && dir instanceof NewVirtualFile && ApplicationManager.getApplication().isDispatchThread()) {
            child = ((NewVirtualFile)dir).refreshAndFindChild(moduleName);
        }
        if (child != null && (ok = NodeModuleSearchUtil.canLoad(child))) {
            String name = child.isDirectory() ? child.getName() : child.getNameWithoutExtension();
            modules.add(new CompletionModuleInfo(name, child, moduleType));
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<CompletionModuleInfo> collectVisibleNodeModules(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectVisibleNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectVisibleNodeModules"));
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromNodeModulesDir(modules, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromResourceRoots(modules, project, requester);
        }
        if (nodeSettings != null) {
            NodeModuleSearchUtil.collectModulesFromGlobalFolders(modules, nodeSettings.getGlobalFolders());
        }
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectVisibleNodeModules"));
        }
        return collection;
    }

    private static void collectModulesFromResourceRoots(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromResourceRoots"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromResourceRoots"));
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        if (pathsConfiguration != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            NodeModuleSearchUtil.collectModulesInDirectories(directories, modules, ModuleType.RESOURCE_ROOT);
        }
        if (requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            NodeModuleSearchUtil.collectModulesInDirectories(resourceRoots, modules, ModuleType.RESOURCE_ROOT);
        }
    }

    private static void collectModulesFromNodeModulesDir(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromNodeModulesDir"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromNodeModulesDir"));
        }
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromNodeModulesDir"));
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$collectModulesFromNodeModulesDir$2"));
            }
            NodeModuleSearchUtil.collectModulesInDirectory(nodeModulesDir, modules, ModuleType.NODE_MODULES_DIR);
            return true;
        }));
    }

    private static void collectModulesFromGlobalFolders(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull List<VirtualFile> globalFolders) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromGlobalFolders"));
        }
        if (globalFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesFromGlobalFolders"));
        }
        for (VirtualFile dir : globalFolders) {
            if (!dir.isValid() || !dir.isDirectory()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(dir, modules, ModuleType.GLOBAL_FOLDER);
        }
    }

    public static void collectGloballyInstalledModules(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull NodeSettings nodeSettings) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectGloballyInstalledModules"));
        }
        if (nodeSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeSettings", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectGloballyInstalledModules"));
        }
        VirtualFile dir = nodeSettings.getGlobalNodeModulesVirtualDir();
        if (dir != null) {
            NodeModuleSearchUtil.collectModulesInDirectory(dir, modules, ModuleType.GLOBALLY_INSTALLED);
        }
    }

    private static void collectModulesInDirectories(@NotNull List<VirtualFile> directories, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectories"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectories"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectories"));
        }
        for (VirtualFile directory : directories) {
            if (!directory.isDirectory() || !directory.isValid()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(directory, modules, moduleType);
        }
    }

    private static void collectModulesInDirectory(@NotNull VirtualFile dir, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        VirtualFile[] children;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectory"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectory"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "collectModulesInDirectory"));
        }
        PackageJsonData packageJsonData = null;
        if (StringUtil.equals((CharSequence)dir.getNameSequence(), (CharSequence)NODE_MODULES)) {
            VirtualFile packageJson;
            VirtualFile parent = dir.getParent();
            VirtualFile virtualFile = packageJson = parent != null ? parent.findChild(PACKAGE_JSON) : null;
            if (packageJson != null && !packageJson.isDirectory() && packageJson.isValid()) {
                packageJsonData = PackageJsonUtil.getOrCreateData(packageJson);
            }
        }
        for (VirtualFile child : children = VfsUtil.getChildren((VirtualFile)dir)) {
            String name;
            boolean ok = NodeModuleSearchUtil.canLoad(child);
            if (!ok) continue;
            if (child.isDirectory()) {
                name = child.getName();
                if (packageJsonData != null && !packageJsonData.isDependencyOfAnyType(name)) {
                    continue;
                }
            } else {
                name = child.getNameWithoutExtension();
            }
            if (modules.containsKey(name)) continue;
            modules.put(name, new CompletionModuleInfo(name, child, moduleType));
        }
    }

    private static boolean canLoad(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "canLoad"));
        }
        if (fileOrDir.isDirectory()) {
            return NodeModuleSearchUtil.canLoadDirectory(fileOrDir);
        }
        return NodeModuleSearchUtil.canLoadFile(fileOrDir);
    }

    public static boolean canLoadFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "canLoadFile"));
        }
        String ext = file.getExtension();
        if (ext == null) {
            return false;
        }
        for (String expectedExt : FILE_EXTENSIONS_IN_ORDER) {
            if (!expectedExt.endsWith(ext) || ext.length() + 1 != expectedExt.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean canLoadDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "canLoadDirectory"));
        }
        VirtualFile packageJson = dir.findChild(PACKAGE_JSON);
        if (NodeModuleSearchUtil.isFile(packageJson)) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS_IN_ORDER) {
            VirtualFile child = dir.findChild("index" + ext);
            if (!NodeModuleSearchUtil.isFile(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester, @Nullable NodeSettings nodeSettings, @NotNull List<VirtualFile> nodePathFolders, boolean respectResourceRoots, @Nullable Project project) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModule"));
        }
        if (nodePathFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModule"));
        }
        ResolvedModuleInfo info = null;
        if (requester != null) {
            info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, NodeModuleDirectorySearchProcessor.PROCESSOR);
        }
        if (info == null && respectResourceRoots && project != null) {
            info = NodeModuleSearchUtil.resolveModuleFromResourceRoots(project, requiredModuleName, requester);
        }
        if (info == null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodePathFolders);
        }
        if (info == null && nodeSettings != null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodeSettings.getGlobalFolders());
        }
        return info;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleFromNodeModulesDir(@NotNull VirtualFile requester, @NotNull String requiredModuleName, @NotNull NodeModuleDirectorySearchProcessor processor) {
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromNodeModulesDir"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromNodeModulesDir"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromNodeModulesDir"));
        }
        Ref resolveRef = Ref.create();
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$resolveModuleFromNodeModulesDir$3"));
            }
            if (requiredModuleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "lambda$resolveModuleFromNodeModulesDir$3"));
            }
            ResolvedModuleInfo info = processor.doResolveModule(null, ModuleType.NODE_MODULES_DIR, (VirtualFile)nodeModulesDir, requiredModuleName, true, true);
            if (info != null) {
                resolveRef.set((Object)info);
                return false;
            }
            return true;
        }));
        return (ResolvedModuleInfo)resolveRef.get();
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromResourceRoots(@NotNull Project project, @NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromResourceRoots"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromResourceRoots"));
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        ResolvedModuleInfo info = null;
        if (pathsConfiguration != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, directories);
        }
        if (info == null && requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, resourceRoots);
        }
        return info;
    }

    @NotNull
    private static List<VirtualFile> getJavaResourceRoots(@NotNull Project project, @NotNull VirtualFile requester) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
        }
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
        }
        if (!PlatformUtils.isIdeaUltimate()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
            }
            return list;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = index.getModuleForFile(requester, false);
        if (module == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getJavaResourceRoots"));
        }
        return list;
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleInResourceRoots(@NotNull String requiredModuleName, @NotNull List<VirtualFile> resourceRoots) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleInResourceRoots"));
        }
        if (resourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceRoots", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleInResourceRoots"));
        }
        if (resourceRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile rootDir : resourceRoots) {
            ResolvedModuleInfo info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.RESOURCE_ROOT, rootDir, requiredModuleName, true, true);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static void processUpNodeModulesDirs(@Nullable Project project, @NotNull VirtualFile requester, @NotNull Processor<VirtualFile> nodeModulesDirProcessor) {
        boolean continueIteration;
        VirtualFile nodeModulesDir;
        ProjectFileIndex index;
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "processUpNodeModulesDirs"));
        }
        if (nodeModulesDirProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDirProcessor", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "processUpNodeModulesDirs"));
        }
        VirtualFile dir = requester;
        if (!dir.isDirectory()) {
            dir = requester.getParent();
        }
        ProjectFileIndex projectFileIndex = index = project == null ? null : ProjectFileIndex.SERVICE.getInstance((Project)project);
        while (!(dir == null || index != null && index.getContentRootForFile(dir, false) == null || (nodeModulesDir = dir.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory() && nodeModulesDir.isValid() && !(continueIteration = nodeModulesDirProcessor.process((Object)nodeModulesDir)))) {
            dir = dir.getParent();
        }
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromGlobalFolders(@NotNull String requiredModuleName, @NotNull List<VirtualFile> globalFolders) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromGlobalFolders"));
        }
        if (globalFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFolders", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleFromGlobalFolders"));
        }
        for (VirtualFile dir : globalFolders) {
            ResolvedModuleInfo info;
            if (!dir.isValid() || !dir.isDirectory() || (info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.GLOBAL_FOLDER, dir, requiredModuleName, true, true)) == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleByExactPath(@NotNull VirtualFile baseDir, @NotNull String requiredModuleName) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleByExactPath"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "resolveModuleByExactPath"));
        }
        return NodeModuleSearchUtil.doResolveModule(null, ModuleType.EXACT_PATH, baseDir, requiredModuleName, true, true);
    }

    @Nullable
    private static ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "doResolveModule"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "doResolveModule"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "doResolveModule"));
        }
        return NodeModuleDirectorySearchProcessor.PROCESSOR.doResolveModule(moduleSourceRoot, type, baseDir, requiredModuleName, resolveDirectory, respectPackageJson);
    }

    @NotNull
    public static Pair<Boolean, VirtualFile> findMainModuleInPackage(@NotNull VirtualFile dir) {
        String main;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleInPackage"));
        }
        VirtualFile packageJson = dir.findChild(PACKAGE_JSON);
        if (packageJson != null && (main = NodeModuleSearchUtil.findMainKeyValueInPackageJson(packageJson)) != null) {
            String[] parts = (main = main.startsWith("./") ? main.substring(2) : main).split("/");
            VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
            if (file == null && parts.length > 0 && !parts[parts.length - 1].contains(".")) {
                String withoutExtension = parts[parts.length - 1];
                parts[parts.length - 1] = withoutExtension + ".js";
                file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                if (file == null) {
                    parts[parts.length - 1] = withoutExtension + ".node";
                    file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                }
            }
            Pair pair = Pair.create((Object)true, (Object)file);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleInPackage"));
            }
            return pair;
        }
        VirtualFile candidate = dir.findChild("index.js");
        if (candidate == null) {
            candidate = dir.findChild("index.node");
        }
        Pair pair = Pair.create((Object)false, (Object)candidate);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainModuleInPackage"));
        }
        return pair;
    }

    public static String getRedirectPathForModule(@NotNull Project project, @NotNull VirtualFile mainModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getRedirectPathForModule"));
        }
        if (mainModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainModule", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "getRedirectPathForModule"));
        }
        Pair value = REDIRECT_PATHS_CACHE.get(mainModule);
        if (value != null && ((Long)value.second).longValue() != mainModule.getModificationCount()) {
            value = null;
        }
        if (value == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(mainModule);
            if (psiFile == null) {
                return null;
            }
            String path = CommonJSUtil.getNodeJsRedirectPath(psiFile);
            value = Pair.create((Object)path, (Object)mainModule.getModificationCount());
            REDIRECT_PATHS_CACHE.put(mainModule, (Pair<String, Long>)value);
        }
        return (String)value.first;
    }

    @Nullable
    static String findMainKeyValueInPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findMainKeyValueInPackageJson"));
        }
        Pair value = MAIN_KEY_VALUE_FROM_PACKAGE_JSON_CACHE.get(packageJson);
        if (value != null && ((Long)value.second).longValue() != packageJson.getModificationCount()) {
            value = null;
        }
        if (value == null) {
            String mainPath = NodeModuleSearchUtil.calcMainKeyValueInPackageJson(packageJson);
            value = Pair.create((Object)mainPath, (Object)packageJson.getModificationCount());
            MAIN_KEY_VALUE_FROM_PACKAGE_JSON_CACHE.put(packageJson, (Pair<String, Long>)value);
        }
        return (String)value.first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String calcMainKeyValueInPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "calcMainKeyValueInPackageJson"));
        }
        JsonReader jsonReader = null;
        try {
            String text = VfsUtilCore.loadText((VirtualFile)packageJson);
            jsonReader = new JsonReader((Reader)new StringReader(text));
            String string = JsonUtil.getChildAsString((JsonReader)jsonReader, (String)"main");
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Contract(value="null -> false", pure=true)
    static boolean isFile(@Nullable VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory();
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isDirectory(@Nullable VirtualFile dir) {
        return dir != null && dir.isValid() && dir.isDirectory();
    }

    @Nullable
    public static VirtualFile findAncestorNodeModulesDir(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findAncestorNodeModulesDir"));
        }
        for (VirtualFile f = fileOrDir.getParent(); f != null; f = f.getParent()) {
            if (!StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)f.getNameSequence())) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDependencyRoot(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/NodeModuleSearchUtil", "findDependencyRoot"));
        }
        VirtualFile scope = fileOrDir;
        VirtualFile pkg = fileOrDir;
        while (scope != null) {
            VirtualFile parent = scope.getParent();
            if (parent != null && parent.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)parent.getNameSequence())) {
                return NodeModuleSearchUtil.isScopeName(scope) ? pkg : scope;
            }
            pkg = scope;
            scope = parent;
        }
        return null;
    }

    public static boolean isScopeName(@Nullable VirtualFile dir) {
        return dir != null && StringUtil.startsWith((CharSequence)dir.getNameSequence(), (CharSequence)"@");
    }
}

