/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsUtil {
    public static final String NPM_EXE_FILE_BASE_NAME = SystemInfo.isWindows ? "npm.cmd" : "npm";
    private static final String NODEJS_INTERPRETER_PATH = "nodejs_interpreter_path";
    private static final String NODEJS_INTERPRETER_VERSION = "nodejs_interpreter_version";
    private static volatile NodeSettings CURRENT;

    private NodeSettingsUtil() {
    }

    public static void setSettings(@NotNull Project project, @NotNull NodeSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeSettingsUtil", "setSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/nodejs/NodeSettingsUtil", "setSettings"));
        }
        NodeSettingsUtil.setInterpreterPath(project, settings.getInterpreterPath());
    }

    public static void setInterpreterPath(@NotNull Project project, @NotNull String nodeInterpreterPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeSettingsUtil", "setInterpreterPath"));
        }
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/javascript/nodejs/NodeSettingsUtil", "setInterpreterPath"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(NODEJS_INTERPRETER_PATH, nodeInterpreterPath);
        PropertiesComponent.getInstance().setValue(NODEJS_INTERPRETER_PATH, nodeInterpreterPath);
        NodeLocalVersionsManager.getInstance().addInterpreterPath(nodeInterpreterPath);
        CURRENT = null;
    }

    @NotNull
    public static NodeSettings getSettings(@NotNull Project project) {
        File nodeInterpreterFile;
        NodeSettings nodeSettings;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getSettings"));
        }
        String interpreterPath = PropertiesComponent.getInstance((Project)project).getValue(NODEJS_INTERPRETER_PATH);
        if (interpreterPath == null) {
            interpreterPath = PropertiesComponent.getInstance().getValue(NODEJS_INTERPRETER_PATH);
        }
        if ((nodeSettings = CURRENT) != null && nodeSettings.getInterpreterPath().equals(interpreterPath)) {
            NodeSettings nodeSettings2 = nodeSettings;
            if (nodeSettings2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getSettings"));
            }
            return nodeSettings2;
        }
        if (StringUtil.isEmpty((String)interpreterPath) && (nodeInterpreterFile = NodeDetectionUtil.findInterpreterInPath()) != null) {
            interpreterPath = nodeInterpreterFile.getAbsolutePath();
        }
        CURRENT = nodeSettings = new NodeSettings(StringUtil.notNullize((String)interpreterPath));
        NodeSettings nodeSettings3 = nodeSettings;
        if (nodeSettings3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getSettings"));
        }
        return nodeSettings3;
    }

    @NotNull
    public static String getInterpreterPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getInterpreterPath"));
        }
        NodeSettings settings = NodeSettingsUtil.getSettings(project);
        String string = settings.getInterpreterPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getInterpreterPath"));
        }
        return string;
    }

    @Nullable
    public static File guessNpmExecutableFile() {
        return PathEnvironmentVariableUtil.findInPath((String)NPM_EXE_FILE_BASE_NAME);
    }

    public static String getCoreLibraryName(@NotNull SemVer version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getCoreLibraryName"));
        }
        return "Node.js v" + version.getRawVersion() + " Core Modules";
    }

    @Nullable
    public static SemVer getConfiguredInterpreterVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeSettingsUtil", "getConfiguredInterpreterVersion"));
        }
        String version = PropertiesComponent.getInstance((Project)project).getValue(NODEJS_INTERPRETER_VERSION);
        if (version == null) {
            version = PropertiesComponent.getInstance().getValue(NODEJS_INTERPRETER_VERSION);
        }
        return version != null ? SemVer.parseFromText((String)version) : null;
    }

    public static void setConfiguredInterpreterVersion(@NotNull Project project, @Nullable SemVer nodeVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeSettingsUtil", "setConfiguredInterpreterVersion"));
        }
        if (nodeVersion == null) {
            PropertiesComponent.getInstance((Project)project).unsetValue(NODEJS_INTERPRETER_VERSION);
            PropertiesComponent.getInstance().unsetValue(NODEJS_INTERPRETER_VERSION);
        } else {
            PropertiesComponent.getInstance((Project)project).setValue(NODEJS_INTERPRETER_VERSION, nodeVersion.getParsedVersion());
            PropertiesComponent.getInstance().setValue(NODEJS_INTERPRETER_VERSION, nodeVersion.getParsedVersion());
        }
    }
}

