/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.LeftRightJustifyingLayoutManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.Predicate;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class NodeJsInterpreterRenderer
implements ListCellRenderer<NodeJsInterpreter> {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterRenderer.class);
    private final SimpleColoredComponent myNameComp;
    private final SimpleColoredComponent myVersionComp;
    private final JPanel myPanel;
    private final Predicate<NodeJsInterpreter> myIsProjectInterpreter;

    public NodeJsInterpreterRenderer(boolean compact, @NotNull Predicate<NodeJsInterpreter> isProjectInterpreter) {
        if (isProjectInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isProjectInterpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "<init>"));
        }
        this.myNameComp = new SimpleColoredComponent();
        this.myVersionComp = new SimpleColoredComponent();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myIsProjectInterpreter = isProjectInterpreter;
        this.myNameComp.setOpaque(false);
        this.myVersionComp.setOpaque(false);
        JBInsets insets = compact ? new JBInsets(0, 1, 0, 1) : new JBInsets(2, UIUtil.getListCellHPadding(), 2, UIUtil.getListCellHPadding());
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)insets));
        this.myNameComp.setIpad((Insets)JBUI.emptyInsets());
        this.myVersionComp.setIpad((Insets)JBUI.insets((int)0, (int)10, (int)0, (int)0));
        if (compact) {
            this.myNameComp.setMyBorder(null);
            this.myVersionComp.setMyBorder(null);
        }
        JPanel nameContainer = NodeJsInterpreterRenderer.wrapInLeftRightJustifyingContainer(this.myNameComp);
        this.myPanel.add((Component)nameContainer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myVersionComp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    @NotNull
    private static JPanel wrapInLeftRightJustifyingContainer(final @NotNull SimpleColoredComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "wrapInLeftRightJustifyingContainer"));
        }
        JPanel container = new JPanel((LayoutManager)new LeftRightJustifyingLayoutManager()){

            @Override
            public int getBaseline(int width, int height) {
                return component.getBaseline(width, height);
            }
        };
        container.setBorder(IdeBorderFactory.createEmptyBorder());
        container.setOpaque(false);
        container.add((Component)component);
        JPanel jPanel = container;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "wrapInLeftRightJustifyingContainer"));
        }
        return jPanel;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends NodeJsInterpreter> list, NodeJsInterpreter value, int index, boolean isSelected, boolean cellHasFocus) {
        this.myNameComp.clear();
        this.myVersionComp.clear();
        Font baseFont = list.getFont();
        this.myNameComp.setFont(baseFont);
        this.myVersionComp.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)baseFont));
        if (this.myPanel.isEnabled() != list.isEnabled()) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)list.isEnabled(), (boolean)true);
        }
        if (value == null) {
            return this.myPanel;
        }
        this.myPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
        this.myNameComp.setForeground(foreground);
        this.myVersionComp.setForeground(foreground);
        this.customize(list, value, index, isSelected);
        return this.myPanel;
    }

    private void customize(@NotNull JList<? extends NodeJsInterpreter> list, @NotNull NodeJsInterpreter interpreter, int index, boolean isSelected) {
        Ref<SemVer> versionRef;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "customize"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "customize"));
        }
        this.myNameComp.append(interpreter.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myIsProjectInterpreter.apply((Object)interpreter)) {
            SimpleTextAttributes attrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
            this.myNameComp.append("  (Project)", attrs);
        }
        if ((versionRef = interpreter.getCachedVersion()) != null) {
            SemVer version2 = (SemVer)versionRef.get();
            if (version2 != null) {
                this.addVersion(version2, isSelected);
            }
        } else {
            ModalityState modalityState = ModalityState.current();
            interpreter.fetchVersion((NullableConsumer<SemVer>)((NullableConsumer)version -> {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "lambda$customize$1"));
                }
                if (interpreter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "lambda$customize$1"));
                }
                if (version != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (list == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "lambda$null$0"));
                        }
                        if (interpreter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "lambda$null$0"));
                        }
                        NodeJsInterpreterRenderer.scheduleRepaint(list, interpreter, index);
                    }, modalityState);
                }
            }));
        }
    }

    private static void scheduleRepaint(@NotNull JList<? extends NodeJsInterpreter> list, @NotNull NodeJsInterpreter interpreter, int index) {
        NodeJsInterpreter value;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "scheduleRepaint"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "scheduleRepaint"));
        }
        if (!list.isVisible()) {
            return;
        }
        ListModel<? extends NodeJsInterpreter> listModel = list.getModel();
        if (index == -1) {
            if (listModel instanceof NodeJsInterpreterField.NodeJsInterpreterComboBoxModel) {
                ((NodeJsInterpreterField.NodeJsInterpreterComboBoxModel)listModel).repaintSelectedElementIfMatches(interpreter);
            } else {
                LOG.warn("Expected ListModel class: " + NodeJsInterpreterField.NodeJsInterpreterComboBoxModel.class + ", actual: " + listModel.getClass());
            }
        } else if (0 <= index && index < listModel.getSize() && (value = listModel.getElementAt(index)) == interpreter) {
            list.repaint(list.getCellBounds(index, index));
        }
    }

    private void addVersion(@NotNull SemVer version, boolean isSelected) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer", "addVersion"));
        }
        SimpleTextAttributes attrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        this.myVersionComp.append(version.getRawVersion(), attrs);
    }

    void addHeight(int deltaHeight) {
        Insets insets = this.myPanel.getInsets();
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(insets.top + deltaHeight / 2, insets.left, insets.bottom + deltaHeight / 2, insets.right));
    }
}

