/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.actionscript.parsing.ActionScriptParser;
import com.intellij.lang.actionscript.parsing.ActionScriptStatementParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;

public class ActionScriptFunctionParser
extends FunctionParser<ActionScriptParser> {
    private static final Logger LOG = Logger.getInstance(ActionScriptFunctionParser.class);

    protected ActionScriptFunctionParser(ActionScriptParser parser) {
        super(parser);
    }

    @Override
    public void parseFunctionIdentifier() {
        if (!JSKeywordSets.PROPERTY_NAMES.contains(this.builder.getTokenType())) {
            LOG.error(this.builder.getTokenText());
        }
        boolean validQualifier = JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType());
        PsiBuilder.Marker qualifier = this.builder.mark();
        this.builder.advanceLexer();
        while (validQualifier && this.builder.getTokenType() == JSTokenTypes.DOT) {
            qualifier.done(JSElementTypes.REFERENCE_EXPRESSION);
            qualifier = qualifier.precede();
            this.builder.advanceLexer();
            validQualifier = JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType());
            if (!validQualifier) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            this.builder.advanceLexer();
        }
        qualifier.drop();
    }

    @Override
    public IElementType getFunctionDeclarationElementType() {
        return ActionScriptElementTypes.FUNCTION_DECLARATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseAttributesList() {
        PsiBuilder.Marker modifierList = this.builder.mark();
        boolean seenNs = false;
        boolean seenAnyAttributes = false;
        try {
            boolean hasSomethingInAttrList = true;
            boolean hadConditionalCompileBlock = false;
            boolean doNotAllowAttributes = false;
            while (hasSomethingInAttrList) {
                hasSomethingInAttrList = false;
                while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                    if (doNotAllowAttributes) {
                        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]));
                        break;
                    }
                    PsiBuilder.Marker attribute = this.builder.mark();
                    this.builder.advanceLexer();
                    IElementType tokenType = this.builder.getTokenType();
                    if (tokenType == JSTokenTypes.RBRACKET) {
                        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                    } else {
                        if (tokenType == null || !this.isIdentifierToken(tokenType)) {
                            if (seenAnyAttributes) {
                                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                            }
                            attribute.drop();
                            boolean bl = seenAnyAttributes;
                            return bl;
                        }
                        this.builder.advanceLexer();
                    }
                    while (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                        this.parseAttributeBody();
                        if (!this.builder.eof()) continue;
                        attribute.done(JSStubElementTypes.ATTRIBUTE);
                        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                        boolean bl = true;
                        return bl;
                    }
                    this.builder.advanceLexer();
                    attribute.done(JSStubElementTypes.ATTRIBUTE);
                    hasSomethingInAttrList = true;
                }
                if (this.builder.getTokenType() == JSTokenTypes.INCLUDE_KEYWORD) {
                    hasSomethingInAttrList = true;
                    ((ActionScriptStatementParser)((ActionScriptParser)this.myJavaScriptParser).getStatementParser()).parseIncludeDirective();
                }
                if (this.builder.getTokenType() == JSTokenTypes.USE_KEYWORD && !doNotAllowAttributes) {
                    hasSomethingInAttrList = true;
                    ((ActionScriptStatementParser)((ActionScriptParser)this.myJavaScriptParser).getStatementParser()).parseUseNamespaceDirective();
                }
                if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER && !seenNs) {
                    PsiBuilder.Marker identifier = this.builder.mark();
                    hasSomethingInAttrList = true;
                    seenNs = true;
                    PsiBuilder.Marker marker = this.builder.mark();
                    this.builder.advanceLexer();
                    marker.done(JSElementTypes.REFERENCE_EXPRESSION);
                    IElementType tokenType = this.builder.getTokenType();
                    if (!hadConditionalCompileBlock) {
                        if (tokenType == JSTokenTypes.COLON_COLON && ((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).proceedWithNamespaceReference(identifier, false)) {
                            identifier = identifier.precede();
                            identifier.done(JSElementTypes.REFERENCE_EXPRESSION);
                            identifier.precede().done(JSElementTypes.CONDITIONAL_COMPILE_VARIABLE_REFERENCE);
                            hadConditionalCompileBlock = true;
                            seenNs = false;
                        } else if (tokenType == JSTokenTypes.DOT) {
                            while (this.builder.getTokenType() == JSTokenTypes.DOT) {
                                this.builder.advanceLexer();
                                boolean identifierToken = this.isIdentifierToken(this.builder.getTokenType());
                                if (identifierToken) {
                                    this.builder.advanceLexer();
                                }
                                identifier.done(JSElementTypes.REFERENCE_EXPRESSION);
                                identifier = identifier.precede();
                                if (identifierToken) continue;
                                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                                break;
                            }
                            identifier.drop();
                        } else {
                            identifier.drop();
                        }
                    } else {
                        identifier.drop();
                    }
                }
                while (JSTokenTypes.MODIFIERS.contains(this.builder.getTokenType())) {
                    doNotAllowAttributes = true;
                    seenAnyAttributes = true;
                    hasSomethingInAttrList = true;
                    if (this.builder.getTokenType() == JSTokenTypes.NATIVE_KEYWORD || this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
                        this.builder.putUserData(methodsEmptinessKey, (Object)"a");
                    }
                    this.builder.advanceLexer();
                }
                if (!this.builder.eof()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IElementType currentTokenType = this.builder.getTokenType();
            if (seenNs && !seenAnyAttributes && ActionScriptFunctionParser.isNonAttrListOwner(currentTokenType)) {
                modifierList.rollbackTo();
            } else {
                modifierList.done(JSStubElementTypes.ATTRIBUTE_LIST);
            }
        }
        return true;
    }

    private static boolean isNonAttrListOwner(IElementType currentTokenType) {
        return currentTokenType != JSTokenTypes.VAR_KEYWORD && currentTokenType != JSTokenTypes.CONST_KEYWORD && currentTokenType != JSTokenTypes.FUNCTION_KEYWORD && currentTokenType != JSTokenTypes.CLASS_KEYWORD && currentTokenType != JSTokenTypes.INTERFACE_KEYWORD && currentTokenType != JSTokenTypes.NAMESPACE_KEYWORD;
    }

    @Override
    protected boolean hasParameterInitializers() {
        return true;
    }
}

